/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;

    public InternalByteArrayEntity(byte[] byArray, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        this.b = byArray;
        this.off = 0;
        this.len = this.b.length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] byArray, int n, int n2, ContentType contentType) {
        Args.notNull(byArray, "Source byte array");
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n + " len: " + n2 + " b.length: " + byArray.length);
        }
        this.b = byArray;
        this.off = n;
        this.len = n2;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] byArray) {
        this(byArray, null);
    }

    public InternalByteArrayEntity(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, null);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.len;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        outputStream.write(this.b, this.off, this.len);
        outputStream.flush();
    }

    public boolean isStreaming() {
        return false;
    }
}

