/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.InternalHttpRequest;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private final AuthCache authCache;
    private final CredentialsProvider credentialsProvider;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpClient) {
        return new Executor(httpClient != null ? httpClient : CLIENT);
    }

    Executor(HttpClient httpClient) {
        this.httpclient = httpClient;
        this.credentialsProvider = new BasicCredentialsProvider();
        this.authCache = new BasicAuthCache();
    }

    public Executor auth(AuthScope authScope, Credentials credentials) {
        this.credentialsProvider.setCredentials(authScope, credentials);
        return this;
    }

    public Executor auth(HttpHost httpHost, Credentials credentials) {
        AuthScope authScope = httpHost != null ? new AuthScope(httpHost.getHostName(), httpHost.getPort()) : AuthScope.ANY;
        return this.auth(authScope, credentials);
    }

    public Executor authPreemptive(HttpHost httpHost) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(httpHost, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(HttpHost httpHost) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(httpHost, basicScheme);
        return this;
    }

    public Executor auth(Credentials credentials) {
        return this.auth(AuthScope.ANY, credentials);
    }

    public Executor auth(String string, String string2) {
        return this.auth(new UsernamePasswordCredentials(string, string2));
    }

    public Executor auth(String string, String string2, String string3, String string4) {
        return this.auth(new NTCredentials(string, string2, string3, string4));
    }

    public Executor auth(HttpHost httpHost, String string, String string2) {
        return this.auth(httpHost, (Credentials)new UsernamePasswordCredentials(string, string2));
    }

    public Executor auth(HttpHost httpHost, String string, String string2, String string3, String string4) {
        return this.auth(httpHost, (Credentials)new NTCredentials(string, string2, string3, string4));
    }

    public Executor clearAuth() {
        this.credentialsProvider.clear();
        return this;
    }

    public Executor cookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        this.cookieStore.clear();
        return this;
    }

    public Response execute(Request request) throws ClientProtocolException, IOException {
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        httpClientContext.setAttribute("http.auth.auth-cache", this.authCache);
        httpClientContext.setAttribute("http.cookie-store", this.cookieStore);
        InternalHttpRequest internalHttpRequest = request.prepareRequest();
        return new Response(this.httpclient.execute((HttpUriRequest)internalHttpRequest, httpClientContext));
    }

    @Deprecated
    public static void registerScheme(Scheme scheme) {
    }

    @Deprecated
    public static void unregisterScheme(String string) {
    }

    static {
        SSLConnectionSocketFactory sSLConnectionSocketFactory = null;
        try {
            sSLConnectionSocketFactory = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException sSLInitializationException) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext);
            }
            catch (SecurityException securityException) {
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(sSLConnectionSocketFactory != null ? sSLConnectionSocketFactory : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CONNMGR = new PoolingHttpClientConnectionManager(registry);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

