/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    public static String byteCountToDisplaySize(long l) {
        String string = l / 0x40000000L > 0L ? String.valueOf(l / 0x40000000L) + " GB" : (l / 0x100000L > 0L ? String.valueOf(l / 0x100000L) + " MB" : (l / 1024L > 0L ? String.valueOf(l / 1024L) + " KB" : String.valueOf(l) + " bytes"));
        return string;
    }

    public static void touch(File file) throws IOException {
        boolean bl;
        if (!file.exists()) {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.closeQuietly(fileOutputStream);
        }
        if (!(bl = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection collection) {
        return collection.toArray(new File[collection.size()]);
    }

    private static void innerListFiles(Collection collection, File file, IOFileFilter iOFileFilter) {
        File[] fileArray = file.listFiles(iOFileFilter);
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    FileUtils.innerListFiles(collection, fileArray[n], iOFileFilter);
                } else {
                    collection.add(fileArray[n]);
                }
                ++n;
            }
        }
    }

    public static Collection listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'directory' is not a directory");
        }
        if (iOFileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
        IOFileFilter iOFileFilter3 = FileFilterUtils.andFileFilter(iOFileFilter, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
        IOFileFilter iOFileFilter4 = iOFileFilter2 == null ? FalseFileFilter.INSTANCE : FileFilterUtils.andFileFilter(iOFileFilter2, DirectoryFileFilter.INSTANCE);
        LinkedList linkedList = new LinkedList();
        FileUtils.innerListFiles(linkedList, file, FileFilterUtils.orFileFilter(iOFileFilter3, iOFileFilter4));
        return linkedList;
    }

    public static Iterator iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    private static String[] toSuffixes(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = "." + stringArray[n];
            ++n;
        }
        return stringArray2;
    }

    public static Collection listFiles(File file, String[] stringArray, boolean bl) {
        IOFileFilter iOFileFilter;
        if (stringArray == null) {
            iOFileFilter = TrueFileFilter.INSTANCE;
        } else {
            String[] stringArray2 = FileUtils.toSuffixes(stringArray);
            iOFileFilter = new SuffixFileFilter(stringArray2);
        }
        return FileUtils.listFiles(file, iOFileFilter, bl ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static Iterator iterateFiles(File file, String[] stringArray, boolean bl) {
        return FileUtils.listFiles(file, stringArray, bl).iterator();
    }

    public static boolean contentEquals(File file, File file2) throws IOException {
        boolean bl;
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (file.length() != file2.length()) {
            return false;
        }
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file2);
            bl = IOUtils.contentEquals(fileInputStream, fileInputStream2);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileInputStream2);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        IOUtils.closeQuietly(fileInputStream2);
        return bl;
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        int n = 0;
        while ((n = string.indexOf(37, n)) >= 0) {
            if (n + 2 >= string.length()) continue;
            String string2 = string.substring(n + 1, n + 3);
            char c = (char)Integer.parseInt(string2, 16);
            string = string.substring(0, n) + c + string.substring(n + 3);
        }
        return new File(string);
    }

    public static File[] toFiles(URL[] uRLArray) {
        if (uRLArray == null || uRLArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            if (uRL != null) {
                if (!uRL.getProtocol().equals("file")) {
                    throw new IllegalArgumentException("URL could not be converted to a File: " + uRL);
                }
                fileArray[n] = FileUtils.toFile(uRL);
            }
            ++n;
        }
        return fileArray;
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        int n = 0;
        while (n < uRLArray.length) {
            uRLArray[n] = fileArray[n].toURL();
            ++n;
        }
        return uRLArray;
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl) throws IOException {
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyFile(file, new File(file2, file.getName()), bl);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        FileUtils.doCopyFile(file, file2, bl);
    }

    private static void doCopyFile(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' exists but is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileOutputStream);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        if (file.length() != file2.length()) {
            throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "'");
        }
        if (bl) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static void copyDirectoryToDirectory(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Source '" + file2 + "' is not a directory");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is not a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        FileUtils.doCopyDirectory(file, file2, bl);
    }

    private static void doCopyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is not a directory");
            }
        } else {
            if (!file2.mkdirs()) {
                throw new IOException("Destination '" + file2 + "' directory cannot be created");
            }
            if (bl) {
                file2.setLastModified(file.lastModified());
            }
        }
        if (!file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' cannot be written to");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file3 = new File(file2, fileArray[n].getName());
            if (fileArray[n].isDirectory()) {
                FileUtils.doCopyDirectory(fileArray[n], file3, bl);
            } else {
                FileUtils.doCopyFile(fileArray[n], file3, bl);
            }
            ++n;
        }
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(file);
            try {
                IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileOutputStream);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectory(file);
        if (!file.delete()) {
            String string = "Unable to delete directory " + file + ".";
            throw new IOException(string);
        }
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            ++n;
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static boolean waitFor(File file, int n) {
        int n2 = 0;
        int n3 = 0;
        while (!file.exists()) {
            if (n3++ >= 10) {
                n3 = 0;
                if (n2++ > n) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                break;
            }
        }
        return true;
    }

    public static String readFileToString(File file, String string) throws IOException {
        String string2;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            string2 = IOUtils.toString(fileInputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return string2;
    }

    public static String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString(file, null);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            byArray = IOUtils.toByteArray(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return byArray;
    }

    public static List readLines(File file, String string) throws IOException {
        List list;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            list = IOUtils.readLines(fileInputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return list;
    }

    public static List readLines(File file) throws IOException {
        return FileUtils.readLines(file, null);
    }

    public static LineIterator lineIterator(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator(fileInputStream, string);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(fileInputStream);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            IOUtils.closeQuietly(fileInputStream);
            throw runtimeException;
        }
    }

    public static LineIterator lineIterator(File file) throws IOException {
        return FileUtils.lineIterator(file, null);
    }

    public static void writeStringToFile(File file, String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.write(string, (OutputStream)fileOutputStream, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToFile(file, string, null);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void writeLines(File file, String string, Collection collection) throws IOException {
        FileUtils.writeLines(file, string, collection, null);
    }

    public static void writeLines(File file, Collection collection) throws IOException {
        FileUtils.writeLines(file, null, collection, null);
    }

    public static void writeLines(File file, String string, Collection collection, String string2) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(file);
            IOUtils.writeLines(collection, string2, fileOutputStream, string);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void writeLines(File file, Collection collection, String string) throws IOException {
        FileUtils.writeLines(file, null, collection, string);
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String string = "Unable to delete file: " + file;
                throw new IOException(string);
            }
        }
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        FileUtils.cleanDirectoryOnExit(file);
        file.deleteOnExit();
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        IOException iOException = null;
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            ++n;
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (file.exists()) {
            if (file.isFile()) {
                String string = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static long sizeOfDirectory(File file) {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            l = file2.isDirectory() ? (l += FileUtils.sizeOfDirectory(file2)) : (l += file2.length());
            ++n;
        }
        return l;
    }

    public static boolean isFileNewer(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtils.isFileNewer(file, file2.lastModified());
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, long l) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > l;
    }

    public static boolean isFileOlder(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file + "' doesn't exist");
        }
        return FileUtils.isFileOlder(file, file2.lastModified());
    }

    public static boolean isFileOlder(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, long l) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < l;
    }

    public static long checksumCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        FileUtils.checksum(file, cRC32);
        return cRC32.getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(file), checksum);
            IOUtils.copy((InputStream)checkedInputStream, (OutputStream)new NullOutputStream());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(checkedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(checkedInputStream);
        return checksum;
    }
}

