/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.Option;

public class OptionGroup {
    private HashMap optionMap = new HashMap();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option option) {
        this.optionMap.put("-" + option.getOpt(), option);
        return this;
    }

    public Collection getNames() {
        return this.optionMap.keySet();
    }

    public Collection getOptions() {
        return this.optionMap.values();
    }

    public void setSelected(Option option) throws AlreadySelectedException {
        if (this.selected != null && !this.selected.equals(option.getOpt())) {
            throw new AlreadySelectedException("an option from this group has already been selected: '" + this.selected + "'");
        }
        this.selected = option.getOpt();
    }

    public String getSelected() {
        return this.selected;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getOptions().iterator();
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            stringBuffer.append("-");
            stringBuffer.append(option.getOpt());
            stringBuffer.append(" ");
            stringBuffer.append(option.getDescription());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

