/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.util;

public abstract class LibraryProvider {
    private static LibraryProvider INSTANCE = new SystemLibraryLoader();

    public static void set(LibraryProvider libraryProvider) {
        if (libraryProvider == null) {
            throw new NullPointerException("Provider");
        }
        INSTANCE = libraryProvider;
    }

    public static LibraryProvider get() {
        return INSTANCE;
    }

    public abstract void loadLibrary(String var1);

    private static final class SystemLibraryLoader
    extends LibraryProvider {
        private SystemLibraryLoader() {
        }

        @Override
        public void loadLibrary(String string) {
            System.loadLibrary(string);
        }
    }
}

