/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueColdProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueConsumerFields;
import io.netty.util.internal.shaded.org.jctools.queues.MpscChunkedArrayQueueProducerFields;
import io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.lang.reflect.Field;
import java.util.Iterator;

public class MpscChunkedArrayQueue<E>
extends MpscChunkedArrayQueueConsumerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    long p0;
    long p1;
    long p2;
    long p3;
    long p4;
    long p5;
    long p6;
    long p7;
    long p10;
    long p11;
    long p12;
    long p13;
    long p14;
    long p15;
    long p16;
    long p17;
    private static final long P_INDEX_OFFSET;
    private static final long C_INDEX_OFFSET;
    private static final long P_LIMIT_OFFSET;
    private static final Object JUMP;

    public MpscChunkedArrayQueue(int n) {
        this(Math.max(2, Pow2.roundToPowerOfTwo(n / 8)), n, false);
    }

    public MpscChunkedArrayQueue(int n, int n2, boolean bl) {
        if (n < 2) {
            throw new IllegalArgumentException("Initial capacity must be 2 or more");
        }
        if (n2 < 4) {
            throw new IllegalArgumentException("Max capacity must be 4 or more");
        }
        if (Pow2.roundToPowerOfTwo(n) >= Pow2.roundToPowerOfTwo(n2)) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity(both rounded up to a power of 2)");
        }
        int n3 = Pow2.roundToPowerOfTwo(n);
        long l = n3 - 1 << 1;
        E[] EArray = CircularArrayOffsetCalculator.allocate(n3 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l;
        this.consumerBuffer = EArray;
        this.consumerMask = l;
        this.maxQueueCapacity = (long)Pow2.roundToPowerOfTwo(n2) << 1;
        this.isFixedChunkSize = bl;
        this.soProducerLimit(l);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        Object[] objectArray;
        long l;
        long l2;
        long l3;
        if (null == e) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l3 = this.lvProducerLimit();
            l2 = this.lvProducerIndex();
            if ((l2 & 1L) == 1L) continue;
            l = this.producerMask;
            objectArray = this.producerBuffer;
            if (l3 <= l2) {
                int n = this.offerSlowPath(l, objectArray, l2, l3);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l, objectArray, l2, this.consumerIndex, this.maxQueueCapacity, e);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l2, l2 + 2L)) break;
        }
        l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l);
        UnsafeRefArrayAccess.soElement(objectArray, l3, e);
        return true;
    }

    private int offerSlowPath(long l, E[] EArray, long l2, long l3) {
        long l4 = this.lvConsumerIndex();
        long l5 = this.maxQueueCapacity;
        long l6 = this.getCurrentBufferCapacity(l, l5);
        int n = 0;
        if (l4 + l6 > l2) {
            if (!this.casProducerLimit(l3, l4 + l6)) {
                n = 1;
            }
        } else {
            n = l4 == l2 - l5 ? 2 : (this.casProducerIndex(l2, l2 + 1L) ? 3 : 1);
        }
        return n;
    }

    private static long modifiedCalcElementOffset(long l, long l2) {
        return UnsafeRefArrayAccess.REF_ARRAY_BASE + ((l & l2) << UnsafeRefArrayAccess.REF_ELEMENT_SHIFT - 1);
    }

    @Override
    public E poll() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null) {
            if (l != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
                }
            } else {
                return null;
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l3, null);
        this.soConsumerIndex(l + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null && l != this.lvProducerIndex()) {
            while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l3)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l2), l);
        }
        return (E)object;
    }

    private E[] getNextBuffer(E[] EArray, long l) {
        long l2 = this.nextArrayOffset(l);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvElement(EArray, l2);
        UnsafeRefArrayAccess.soElement(EArray, l2, null);
        return objectArray;
    }

    private long nextArrayOffset(long l) {
        return MpscChunkedArrayQueue.modifiedCalcElementOffset(l + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l) {
        long l2 = this.newBufferAndOffset(EArray, l);
        E e = UnsafeRefArrayAccess.lvElement(EArray, l2);
        if (e == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(EArray, l2, null);
        this.soConsumerIndex(l + 2L);
        return e;
    }

    private E newBufferPeek(E[] EArray, long l) {
        long l2 = this.newBufferAndOffset(EArray, l);
        E e = UnsafeRefArrayAccess.lvElement(EArray, l2);
        if (null == e) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e;
    }

    private long newBufferAndOffset(E[] EArray, long l) {
        this.consumerBuffer = EArray;
        this.consumerMask = EArray.length - 2 << 1;
        long l2 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l, this.consumerMask);
        return l2;
    }

    @Override
    public final int size() {
        long l;
        long l2;
        long l3 = this.lvConsumerIndex();
        do {
            l2 = l3;
            l = this.lvProducerIndex();
        } while (l2 != (l3 = this.lvConsumerIndex()));
        return (int)(l - l3) >> 1;
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }

    private void soProducerIndex(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, l);
    }

    private boolean casProducerIndex(long l, long l2) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_INDEX_OFFSET, l, l2);
    }

    private void soConsumerIndex(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, l);
    }

    private long lvProducerLimit() {
        return this.producerLimit;
    }

    private boolean casProducerLimit(long l, long l2) {
        return UnsafeAccess.UNSAFE.compareAndSwapLong(this, P_LIMIT_OFFSET, l, l2);
    }

    private void soProducerLimit(long l) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_LIMIT_OFFSET, l);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l2);
            return (E)this.newBufferPoll(objectArray2, l);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l3, null);
        this.soConsumerIndex(l + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.consumerBuffer;
        long l = this.consumerIndex;
        long l2 = this.consumerMask;
        long l3 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l, l2);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l3);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l2), l);
        }
        return (E)object;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        long l;
        Object[] objectArray;
        long l2;
        long l3;
        block5: while (true) {
            long l4 = this.lvProducerLimit();
            l3 = this.lvProducerIndex();
            if ((l3 & 1L) == 1L) continue;
            l2 = this.producerMask;
            objectArray = this.producerBuffer;
            l = Math.min(l4, l3 + (long)(2 * n));
            if (l3 == l4 || l4 < l) {
                int n2 = this.offerSlowPath(l2, objectArray, l3, l4);
                switch (n2) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l2, objectArray, l3, this.consumerIndex, this.maxQueueCapacity, supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l3, l)) break;
        }
        int n3 = (int)((l - l3) / 2L);
        int n4 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            long l5 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l3 + (long)(2 * n4), l2);
            UnsafeRefArrayAccess.soElement(objectArray, l5, supplier.get());
        }
        return n3;
    }

    private void resize(long l, E[] EArray, long l2, long l3, long l4, E e) {
        int n = this.getNextBufferCapacity(EArray, l4);
        E[] EArray2 = CircularArrayOffsetCalculator.allocate(n);
        this.producerBuffer = EArray2;
        this.producerMask = n - 2 << 1;
        long l5 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, l);
        long l6 = MpscChunkedArrayQueue.modifiedCalcElementOffset(l2, this.producerMask);
        UnsafeRefArrayAccess.soElement(EArray2, l6, e);
        UnsafeRefArrayAccess.soElement(EArray, this.nextArrayOffset(l), EArray2);
        long l7 = l4 - (l2 - l3);
        if (l7 <= 0L) {
            throw new IllegalStateException();
        }
        this.soProducerLimit(l2 + Math.min(l, l7));
        UnsafeRefArrayAccess.soElement(EArray, l5, JUMP);
        this.soProducerIndex(l2 + 2L);
    }

    private int getNextBufferCapacity(E[] EArray, long l) {
        int n = EArray.length;
        if (this.isFixedChunkSize) {
            n = EArray.length;
        } else {
            if ((long)(EArray.length - 1) == l) {
                throw new IllegalStateException();
            }
            n = 2 * EArray.length - 1;
        }
        return n;
    }

    protected long getCurrentBufferCapacity(long l, long l2) {
        return !this.isFixedChunkSize && l + 2L == l2 ? l2 : l;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        int n;
        long l = 0L;
        int n2 = this.capacity();
        do {
            if ((n = this.fill(supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l;
        } while ((l += (long)n) <= (long)n2);
        return (int)l;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        while (exitCondition.keepRunning()) {
            while (this.fill(supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) != 0) {
            }
            int n = 0;
            while (this.fill(supplier, MpmcArrayQueue.RECOMENDED_OFFER_BATCH) == 0 && exitCondition.keepRunning()) {
                n = waitStrategy.idle(n);
            }
        }
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        int n = 0;
        while (exitCondition.keepRunning()) {
            E e = this.relaxedPoll();
            if (e == null) {
                n = waitStrategy.idle(n);
                continue;
            }
            n = 0;
            consumer.accept(e);
        }
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return this.drain(consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        E e;
        int n2;
        for (n2 = 0; n2 < n && (e = this.relaxedPoll()) != null; ++n2) {
            consumer.accept(e);
        }
        return n2;
    }

    static {
        Field field;
        try {
            field = MpscChunkedArrayQueueProducerFields.class.getDeclaredField("producerIndex");
            P_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = MpscChunkedArrayQueueConsumerFields.class.getDeclaredField("consumerIndex");
            C_INDEX_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        try {
            field = MpscChunkedArrayQueueColdProducerFields.class.getDeclaredField("producerLimit");
            P_LIMIT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(noSuchFieldException);
        }
        JUMP = new Object();
    }
}

