/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE;
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    private static final String[] BYTE2HEX_PAD;
    private static final String[] BYTE2HEX_NOPAD;
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    public static String[] split(String string, char c) {
        int n;
        int n2 = string.length();
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != c) continue;
            if (n3 == n) {
                arrayList.add(EMPTY_STRING);
            } else {
                arrayList.add(string.substring(n3, n));
            }
            n3 = n + 1;
        }
        if (n3 == 0) {
            arrayList.add(string);
        } else if (n3 != n2) {
            arrayList.add(string.substring(n3, n2));
        } else {
            for (n = arrayList.size() - 1; n >= 0 && ((String)arrayList.get(n)).isEmpty(); --n) {
                arrayList.remove(n);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] split(String string, char c, int n) {
        int n2;
        int n3 = string.length();
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList();
        int n4 = 0;
        int n5 = 1;
        for (n2 = 0; n2 < n3 && n5 < n; ++n2) {
            if (string.charAt(n2) != c) continue;
            if (n4 == n2) {
                arrayList.add(EMPTY_STRING);
            } else {
                arrayList.add(string.substring(n4, n2));
            }
            n4 = n2 + 1;
            ++n5;
        }
        if (n4 == 0) {
            arrayList.add(string);
        } else if (n4 != n3) {
            arrayList.add(string.substring(n4, n3));
        } else {
            for (n2 = arrayList.size() - 1; n2 >= 0 && ((String)arrayList.get(n2)).isEmpty(); --n2) {
                arrayList.remove(n2);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String substringAfter(String string, char c) {
        int n = string.indexOf(c);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String string, String string2, int n) {
        return string != null && string2 != null && n >= 0 && string.regionMatches(string.length() - n, string2, string2.length() - n, n);
    }

    public static String byteToHexStringPadded(int n) {
        return BYTE2HEX_PAD[n & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T t, int n) {
        try {
            t.append(StringUtil.byteToHexStringPadded(n));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t;
    }

    public static String toHexStringPadded(byte[] byArray) {
        return StringUtil.toHexStringPadded(byArray, 0, byArray.length);
    }

    public static String toHexStringPadded(byte[] byArray, int n, int n2) {
        return StringUtil.toHexStringPadded(new StringBuilder(n2 << 1), byArray, n, n2).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T t, byte[] byArray) {
        return StringUtil.toHexStringPadded(t, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T t, byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            StringUtil.byteToHexStringPadded(t, byArray[i]);
        }
        return t;
    }

    public static String byteToHexString(int n) {
        return BYTE2HEX_NOPAD[n & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T t, int n) {
        try {
            t.append(StringUtil.byteToHexString(n));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t;
    }

    public static String toHexString(byte[] byArray) {
        return StringUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        return StringUtil.toHexString(new StringBuilder(n2 << 1), byArray, n, n2).toString();
    }

    public static <T extends Appendable> T toHexString(T t, byte[] byArray) {
        return StringUtil.toHexString(t, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexString(T t, byte[] byArray, int n, int n2) {
        int n3;
        assert (n2 >= 0);
        if (n2 == 0) {
            return t;
        }
        int n4 = n + n2;
        int n5 = n4 - 1;
        for (n3 = n; n3 < n5 && byArray[n3] == 0; ++n3) {
        }
        StringUtil.byteToHexString(t, byArray[n3++]);
        int n6 = n4 - n3;
        StringUtil.toHexStringPadded(t, byArray, n3, n6);
        return t;
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String string = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence escapeCsv(CharSequence charSequence) {
        CharSequence charSequence2;
        int n = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n == 0) {
            return charSequence;
        }
        int n2 = n - 1;
        boolean bl = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n2)) && n != 1;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder(n + 7).append('\"');
        block4: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\"': {
                    if (i == 0 || i == n2) {
                        if (bl) continue block4;
                        stringBuilder.append('\"');
                    } else {
                        boolean bl4 = StringUtil.isDoubleQuote(charSequence.charAt(i + 1));
                        if (StringUtil.isDoubleQuote(charSequence.charAt(i - 1)) || bl4 && i + 1 != n2) break;
                        stringBuilder.append('\"');
                        bl3 = true;
                        break;
                    }
                }
                case '\n': 
                case '\r': 
                case ',': {
                    bl2 = true;
                }
            }
            stringBuilder.append(c);
        }
        if (bl3 || bl2 && !bl) {
            charSequence2 = stringBuilder.append('\"');
            return charSequence2;
        }
        charSequence2 = charSequence;
        return charSequence2;
    }

    public static CharSequence unescapeCsv(CharSequence charSequence) {
        boolean bl;
        int n = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n == 0) {
            return charSequence;
        }
        int n2 = n - 1;
        boolean bl2 = bl = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n2)) && n != 1;
        if (!bl) {
            StringUtil.validateCsvFormat(charSequence);
            return charSequence;
        }
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        for (int i = 1; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"') {
                if (StringUtil.isDoubleQuote(charSequence.charAt(i + 1)) && i + 1 != n2) {
                    ++i;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i);
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(2);
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        boolean bl = false;
        int n = charSequence.length() - 1;
        block8: for (int i = 0; i <= n; ++i) {
            char c = charSequence.charAt(i);
            if (bl) {
                switch (c) {
                    case '\"': {
                        char c2;
                        if (i == n) {
                            arrayList.add(stringBuilder.toString());
                            return arrayList;
                        }
                        if ((c2 = charSequence.charAt(++i)) == '\"') {
                            stringBuilder.append('\"');
                            break;
                        }
                        if (c2 == ',') {
                            bl = false;
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i - 1);
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case ',': {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (stringBuilder.length() == 0) {
                        bl = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i);
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (bl) {
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, n);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static void validateCsvFormat(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            switch (charSequence.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static boolean endsWith(CharSequence charSequence, char c) {
        int n = charSequence.length();
        return n > 0 && charSequence.charAt(n - 1) == c;
    }

    private StringUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        StringBuilder stringBuilder;
        int n;
        String string;
        BYTE2HEX_PAD = new String[256];
        BYTE2HEX_NOPAD = new String[256];
        Formatter formatter = new Formatter();
        try {
            string = formatter.format("%n", new Object[0]).toString();
        }
        catch (Exception exception) {
            string = "\n";
        }
        finally {
            formatter.close();
        }
        NEWLINE = string;
        for (n = 0; n < 10; ++n) {
            stringBuilder = new StringBuilder(2);
            stringBuilder.append('0');
            stringBuilder.append(n);
            StringUtil.BYTE2HEX_PAD[n] = stringBuilder.toString();
            StringUtil.BYTE2HEX_NOPAD[n] = String.valueOf(n);
        }
        while (n < 16) {
            stringBuilder = new StringBuilder(2);
            char c = (char)(97 + n - 10);
            stringBuilder.append('0');
            stringBuilder.append(c);
            StringUtil.BYTE2HEX_PAD[n] = stringBuilder.toString();
            StringUtil.BYTE2HEX_NOPAD[n] = String.valueOf(c);
            ++n;
        }
        while (n < BYTE2HEX_PAD.length) {
            String string2;
            stringBuilder = new StringBuilder(2);
            stringBuilder.append(Integer.toHexString(n));
            StringUtil.BYTE2HEX_PAD[n] = string2 = stringBuilder.toString();
            StringUtil.BYTE2HEX_NOPAD[n] = string2;
            ++n;
        }
    }
}

