/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.NetUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MacAddressUtil {
    public static final int MAC_ADDRESS_LENGTH = 8;
    private static final byte[] NOT_FOUND = new byte[]{-1};
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);

    public static byte[] bestAvailableMac() {
        InetAddress inetAddress;
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2 = NOT_FOUND;
        InetAddress inetAddress2 = NetUtil.LOCALHOST4;
        LinkedHashMap<NetworkInterface, InetAddress> linkedHashMap = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            object = NetworkInterface.getNetworkInterfaces();
            while (object.hasMoreElements()) {
                NetworkInterface object3 = object.nextElement();
                enumeration = object3.getInetAddresses();
                if (!enumeration.hasMoreElements() || (inetAddress = enumeration.nextElement()).isLoopbackAddress()) continue;
                linkedHashMap.put(object3, inetAddress);
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            byte[] byArray;
            enumeration = (NetworkInterface)entry.getKey();
            inetAddress = (InetAddress)entry.getValue();
            if (((NetworkInterface)((Object)enumeration)).isVirtual()) continue;
            try {
                byArray = ((NetworkInterface)((Object)enumeration)).getHardwareAddress();
            }
            catch (SocketException socketException) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)enumeration, (Object)socketException);
                continue;
            }
            boolean bl = false;
            int n = MacAddressUtil.compareAddresses(object2, byArray);
            if (n < 0) {
                bl = true;
            } else if (n == 0) {
                n = MacAddressUtil.compareAddresses(inetAddress2, inetAddress);
                if (n < 0) {
                    bl = true;
                } else if (n == 0 && ((byte[])object2).length < byArray.length) {
                    bl = true;
                }
            }
            if (!bl) continue;
            object2 = byArray;
            inetAddress2 = inetAddress;
        }
        if (object2 == NOT_FOUND) {
            return null;
        }
        switch (((byte[])object2).length) {
            case 6: {
                object = new byte[8];
                System.arraycopy(object2, 0, object, 0, 3);
                object[3] = -1;
                object[4] = -2;
                System.arraycopy(object2, 3, object, 5, 3);
                object2 = object;
                break;
            }
            default: {
                object2 = Arrays.copyOf(object2, 8);
            }
        }
        return object2;
    }

    public static String formatAddress(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(24);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x:", by & 0xFF));
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static int compareAddresses(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            return 1;
        }
        if (byArray2.length < 6) {
            return 1;
        }
        boolean bl = true;
        for (byte by : byArray2) {
            if (by == 0 || by == 1) continue;
            bl = false;
            break;
        }
        if (bl) {
            return 1;
        }
        if ((byArray2[0] & 1) != 0) {
            return 1;
        }
        if ((byArray[0] & 2) == 0) {
            if ((byArray2[0] & 2) == 0) {
                return 0;
            }
            return 1;
        }
        if ((byArray2[0] & 2) == 0) {
            return -1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress inetAddress, InetAddress inetAddress2) {
        return MacAddressUtil.scoreAddress(inetAddress) - MacAddressUtil.scoreAddress(inetAddress2);
    }

    private static int scoreAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return 0;
        }
        if (inetAddress.isMulticastAddress()) {
            return 1;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return 2;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

