/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_BYTE_COUNT = 4;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final InternalLogger logger;

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String string) {
        if (NetUtil.isValidIpV4Address(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            byte[] byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                String string2 = stringTokenizer.nextToken();
                int n = Integer.parseInt(string2);
                byArray[i] = (byte)n;
            }
            return byArray;
        }
        if (NetUtil.isValidIpV6Address(string)) {
            int n;
            int n2;
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length() - 1);
            }
            if ((n2 = string.indexOf(37)) >= 0) {
                string = string.substring(0, n2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":.", true);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string3 = "";
            String string4 = "";
            int n3 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                string4 = string3;
                string3 = stringTokenizer.nextToken();
                if (":".equals(string3)) {
                    if (":".equals(string4)) {
                        n3 = arrayList.size();
                        continue;
                    }
                    if (string4.isEmpty()) continue;
                    arrayList.add(string4);
                    continue;
                }
                if (!".".equals(string3)) continue;
                arrayList2.add(string4);
            }
            if (":".equals(string4)) {
                if (":".equals(string3)) {
                    n3 = arrayList.size();
                } else {
                    arrayList.add(string3);
                }
            } else if (".".equals(string4)) {
                arrayList2.add(string3);
            }
            int n4 = 8;
            if (!arrayList2.isEmpty()) {
                n4 -= 2;
            }
            if (n3 != -1) {
                int n5 = n4 - arrayList.size();
                for (n = 0; n < n5; ++n) {
                    arrayList.add(n3, "0");
                }
            }
            byte[] byArray = new byte[16];
            for (n = 0; n < arrayList.size(); ++n) {
                NetUtil.convertToBytes((String)arrayList.get(n), byArray, n << 1);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                byArray[n + 12] = (byte)(Integer.parseInt((String)arrayList2.get(n)) & 0xFF);
            }
            return byArray;
        }
        return null;
    }

    private static void convertToBytes(String string, byte[] byArray, int n) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        byArray[n] = 0;
        byArray[n + 1] = 0;
        if (n3 > 3) {
            n2 = NetUtil.getIntValue(string.charAt(n4++));
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] | n2 << 4);
        }
        if (n3 > 2) {
            n2 = NetUtil.getIntValue(string.charAt(n4++));
            int n6 = n;
            byArray[n6] = (byte)(byArray[n6] | n2);
        }
        if (n3 > 1) {
            n2 = NetUtil.getIntValue(string.charAt(n4++));
            int n7 = n + 1;
            byArray[n7] = (byte)(byArray[n7] | n2 << 4);
        }
        n2 = NetUtil.getIntValue(string.charAt(n4));
        int n8 = n + 1;
        byArray[n8] = (byte)(byArray[n8] | n2 & 0xF);
    }

    private static int getIntValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        c = Character.toLowerCase(c);
        switch (c) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static String intToIpAddress(int n) {
        StringBuilder stringBuilder = new StringBuilder(15);
        stringBuilder.append(n >> 24 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n >> 16 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n >> 8 & 0xFF);
        stringBuilder.append('.');
        stringBuilder.append(n & 0xFF);
        return stringBuilder.toString();
    }

    public static String bytesToIpAddress(byte[] byArray, int n, int n2) {
        if (n2 == 4) {
            StringBuilder stringBuilder = new StringBuilder(15);
            stringBuilder.append(byArray[n++] >> 24 & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byArray[n++] >> 16 & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byArray[n++] >> 8 & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byArray[n] & 0xFF);
            return stringBuilder.toString();
        }
        if (n2 == 16) {
            StringBuilder stringBuilder = new StringBuilder(39);
            int n3 = n + 14;
            while (n < n3) {
                StringUtil.toHexString(stringBuilder, byArray, n, 2);
                stringBuilder.append(':');
                n += 2;
            }
            StringUtil.toHexString(stringBuilder, byArray, n, 2);
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("length: " + n2 + " (expected: 4 or 16)");
    }

    public static boolean isValidIpV6Address(String string) {
        int n;
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        int n5 = 0;
        int n6 = string.length();
        if (n6 < 2) {
            return false;
        }
        if (string.charAt(0) == '[') {
            if (string.charAt(n6 - 1) != ']') {
                return false;
            }
            n5 = 1;
            --n6;
        }
        if ((n = string.indexOf(37, n5)) >= 0) {
            n6 = n;
        }
        block4: for (int i = n5; i < n6; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '.': {
                    if (++n4 > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidIp4Word(stringBuilder.toString())) {
                        return false;
                    }
                    if (n3 != 6 && !bl) {
                        return false;
                    }
                    if (n3 == 7 && string.charAt(n5) != ':' && string.charAt(1 + n5) != ':') {
                        return false;
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    continue block4;
                }
                case ':': {
                    if (i == n5 && (string.length() <= i || string.charAt(i + 1) != ':')) {
                        return false;
                    }
                    if (++n3 > 7) {
                        return false;
                    }
                    if (n4 > 0) {
                        return false;
                    }
                    if (c2 == ':') {
                        if (bl) {
                            return false;
                        }
                        bl = true;
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    continue block4;
                }
                default: {
                    if (stringBuilder != null && stringBuilder.length() > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidHexChar(c)) {
                        return false;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        if (n4 > 0) {
            if (n4 != 3 || !NetUtil.isValidIp4Word(stringBuilder.toString()) || n3 >= 7) {
                return false;
            }
        } else {
            if (n3 != 7 && !bl) {
                return false;
            }
            if (stringBuilder.length() == 0 && string.charAt(n2 - 1 - n5) == ':' && string.charAt(n2 - 2 - n5) != ':') {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidIp4Word(String string) {
        if (string.length() < 1 || string.length() > 3) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return Integer.parseInt(string) <= 255;
    }

    private static boolean isValidHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidNumericChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isValidIpV4Address(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 15) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                if (++n > 3) {
                    return false;
                }
                if (stringBuilder.length() == 0) {
                    return false;
                }
                if (Integer.parseInt(stringBuilder.toString()) > 255) {
                    return false;
                }
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (!Character.isDigit(c)) {
                return false;
            }
            if (stringBuilder.length() > 2) {
                return false;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() == 0 || Integer.parseInt(stringBuilder.toString()) > 255) {
            return false;
        }
        return n == 3;
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence charSequence, boolean bl) {
        int n;
        char c;
        int n2;
        byte[] byArray = new byte[16];
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = false;
        block6: for (n2 = 0; n2 < n3; ++n2) {
            c = charSequence.charAt(n2);
            switch (c) {
                case ':': {
                    if (n2 - n8 > 4 || n10 > 0 || ++n9 > 8 || n6 + 1 >= byArray.length) {
                        return null;
                    }
                    n7 <<= 4 - (n2 - n8) << 2;
                    if (n5 > 0) {
                        n5 -= 2;
                    }
                    byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
                    byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
                    n = n2 + 1;
                    if (n < n3 && charSequence.charAt(n) == ':') {
                        if (n4 != 0 || ++n < n3 && charSequence.charAt(n) == ':') {
                            return null;
                        }
                        bl2 = ++n9 == 2 && n7 == 0;
                        n4 = n6;
                        n5 = byArray.length - n4 - 2;
                        ++n2;
                    }
                    n7 = 0;
                    n8 = -1;
                    continue block6;
                }
                case '.': {
                    if (n2 - n8 > 3 || ++n10 > 3 || n9 > 0 && n6 + n5 < 12 || n2 + 1 >= n3 || n6 >= byArray.length || n8 < 0 || n8 == 0 && (n2 == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(2)) || !NetUtil.isValidNumericChar(charSequence.charAt(1)) || !NetUtil.isValidNumericChar(charSequence.charAt(0))) || n2 == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(1)) || !NetUtil.isValidNumericChar(charSequence.charAt(0))) || n2 == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(0)))) {
                        return null;
                    }
                    if ((n8 = ((n7 <<= 3 - (n2 - n8) << 2) & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF)) < 0 || n8 > 255) {
                        return null;
                    }
                    byArray[n6++] = (byte)n8;
                    n7 = 0;
                    n8 = -1;
                    continue block6;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c) || n10 > 0 && !NetUtil.isValidNumericChar(c)) {
                        return null;
                    }
                    if (n8 < 0) {
                        n8 = n2;
                    } else if (n2 - n8 > 4) {
                        return null;
                    }
                    n7 += NetUtil.getIntValue(c) << (n2 - n8 << 2);
                }
            }
        }
        char c2 = c = n4 > 0 ? (char)'\u0001' : '\u0000';
        if (n10 > 0) {
            if (n8 > 0 && n2 - n8 > 3 || n10 != 3 || n6 >= byArray.length) {
                return null;
            }
            if (n9 == 0) {
                n5 = 12;
            } else if (n9 >= 2 && charSequence.charAt(n3 - 1) != ':' && (c == '\u0000' && n9 == 6 && charSequence.charAt(0) != ':' || c != '\u0000' && n9 + 1 < 8 && (charSequence.charAt(0) != ':' || n4 <= 2))) {
                n5 -= 2;
            } else {
                return null;
            }
            n7 <<= 3 - (n2 - n8) << 2;
            n8 = (n7 & 0xF) * 100 + (n7 >> 4 & 0xF) * 10 + (n7 >> 8 & 0xF);
            if (n8 < 0 || n8 > 255) {
                return null;
            }
            byArray[n6++] = (byte)n8;
        } else {
            n = n3 - 1;
            if (n8 > 0 && n2 - n8 > 4 || n9 < 2 || c == '\u0000' && (n9 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n) == ':') || c != '\u0000' && (n9 > 8 || n9 == 8 && (n4 <= 2 && charSequence.charAt(0) != ':' || n4 >= 14 && charSequence.charAt(n) != ':')) || n6 + 1 >= byArray.length) {
                return null;
            }
            if (n8 >= 0 && n2 - n8 <= 4) {
                n7 <<= 4 - (n2 - n8) << 2;
            }
            byArray[n6++] = (byte)((n7 & 0xF) << 4 | n7 >> 4 & 0xF);
            byArray[n6++] = (byte)((n7 >> 8 & 0xF) << 4 | n7 >> 12 & 0xF);
        }
        n2 = n6 + n5;
        if (bl2 || n2 >= byArray.length) {
            if (n2 >= byArray.length) {
                ++n4;
            }
            for (n2 = n6; n2 < byArray.length; ++n2) {
                for (n8 = byArray.length - 1; n8 >= n4; --n8) {
                    byArray[n8] = byArray[n8 - 1];
                }
                byArray[n8] = 0;
                ++n4;
            }
        } else {
            for (n2 = 0; n2 < n5 && (n6 = (n8 = n2 + n4) + n5) < byArray.length; ++n2) {
                byArray[n6] = byArray[n8];
                byArray[n8] = 0;
            }
        }
        if (bl && n10 > 0 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        try {
            return Inet6Address.getByAddress(null, byArray, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress inetAddress, boolean bl) {
        int n;
        if (inetAddress instanceof Inet4Address) {
            return inetAddress.getHostAddress();
        }
        if (!(inetAddress instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + inetAddress.getClass());
        }
        byte[] byArray = inetAddress.getAddress();
        int[] nArray = new int[8];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (byArray[n << 1] & 0xFF) << 8 | byArray[(n << 1) + 1] & 0xFF;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) {
                if (n2 >= 0) continue;
                n2 = n;
                continue;
            }
            if (n2 < 0) continue;
            n3 = n - n2;
            if (n3 > n5) {
                n4 = n2;
                n5 = n3;
            }
            n2 = -1;
        }
        if (n2 >= 0 && (n3 = n - n2) > n5) {
            n4 = n2;
            n5 = n3;
        }
        if (n5 == 1) {
            n5 = 0;
            n4 = -1;
        }
        int n6 = n4 + n5;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n6 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n = 1; n < nArray.length; ++n) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n]));
            }
        } else {
            boolean bl2;
            if (NetUtil.inRangeEndExclusive(0, n4, n6)) {
                stringBuilder.append("::");
                bl2 = bl && n6 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl2 = false;
            }
            for (n = 1; n < nArray.length; ++n) {
                if (!NetUtil.inRangeEndExclusive(n, n4, n6)) {
                    if (!NetUtil.inRangeEndExclusive(n - 1, n4, n6)) {
                        if (!bl2 || n == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl2 && n > 5) {
                        stringBuilder.append(nArray[n] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n - 1, n4, n6)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    private static boolean inRangeEndExclusive(int n, int n2, int n3) {
        return n >= n2 && n < n3;
    }

    private NetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2;
        IPV4_PREFERRED = Boolean.getBoolean("java.net.preferIPv4Stack");
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        byte[] byArray = new byte[]{127, 0, 0, 1};
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress("localhost", byArray);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST4 = inet4Address;
        Inet6Address inet6Address = null;
        try {
            inet6Address = (Inet6Address)InetAddress.getByAddress("localhost", byArray2);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
        }
        LOCALHOST6 = inet6Address;
        ArrayList<NetworkInterface> arrayList = new ArrayList<NetworkInterface>();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!((NetworkInterface)object).getInetAddresses().hasMoreElements()) continue;
                arrayList.add((NetworkInterface)object);
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        block14: for (NetworkInterface networkInterface : arrayList) {
            enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block14;
            }
        }
        if (object2 == null) {
            try {
                for (NetworkInterface networkInterface : arrayList) {
                    if (!networkInterface.isLoopback() || !(enumeration = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", (Object)inet6Address);
                    object = inet6Address;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
        }
        LOOPBACK_IF = object2;
        LOCALHOST = object;
        SOMAXCONN = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() {
                int n = PlatformDependent.isWindows() ? 200 : 128;
                File file = new File("/proc/sys/net/core/somaxconn");
                BufferedReader bufferedReader = null;
                try {
                    if (file.exists()) {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        n = Integer.parseInt(bufferedReader.readLine());
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: {}", (Object)file, (Object)n);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("{}: {} (non-existent)", (Object)file, (Object)n);
                    }
                }
                catch (Exception exception) {
                    logger.debug("Failed to get SOMAXCONN from: {}", (Object)file, (Object)exception);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                return n;
            }
        });
    }
}

