/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.DefaultDnsServerAddresses;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.RotationalDnsServerAddresses;
import io.netty.resolver.dns.SequentialDnsServerAddressStream;
import io.netty.resolver.dns.ShuffledDnsServerAddressStream;
import io.netty.resolver.dns.SingletonDnsServerAddresses;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class DnsServerAddresses {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsServerAddresses.class);
    private static final List<InetSocketAddress> DEFAULT_NAME_SERVER_LIST;
    private static final InetSocketAddress[] DEFAULT_NAME_SERVER_ARRAY;
    private static final DnsServerAddresses DEFAULT_NAME_SERVERS;

    public static List<InetSocketAddress> defaultAddressList() {
        return DEFAULT_NAME_SERVER_LIST;
    }

    public static DnsServerAddresses defaultAddresses() {
        return DEFAULT_NAME_SERVERS;
    }

    public static DnsServerAddresses sequential(Iterable<? extends InetSocketAddress> iterable) {
        return DnsServerAddresses.sequential0(DnsServerAddresses.sanitize(iterable));
    }

    public static DnsServerAddresses sequential(InetSocketAddress ... inetSocketAddressArray) {
        return DnsServerAddresses.sequential0(DnsServerAddresses.sanitize(inetSocketAddressArray));
    }

    private static DnsServerAddresses sequential0(InetSocketAddress ... inetSocketAddressArray) {
        if (inetSocketAddressArray.length == 1) {
            return DnsServerAddresses.singleton(inetSocketAddressArray[0]);
        }
        return new DefaultDnsServerAddresses("sequential", inetSocketAddressArray){

            @Override
            public DnsServerAddressStream stream() {
                return new SequentialDnsServerAddressStream(this.addresses, 0);
            }
        };
    }

    public static DnsServerAddresses shuffled(Iterable<? extends InetSocketAddress> iterable) {
        return DnsServerAddresses.shuffled0(DnsServerAddresses.sanitize(iterable));
    }

    public static DnsServerAddresses shuffled(InetSocketAddress ... inetSocketAddressArray) {
        return DnsServerAddresses.shuffled0(DnsServerAddresses.sanitize(inetSocketAddressArray));
    }

    private static DnsServerAddresses shuffled0(InetSocketAddress[] inetSocketAddressArray) {
        if (inetSocketAddressArray.length == 1) {
            return DnsServerAddresses.singleton(inetSocketAddressArray[0]);
        }
        return new DefaultDnsServerAddresses("shuffled", inetSocketAddressArray){

            @Override
            public DnsServerAddressStream stream() {
                return new ShuffledDnsServerAddressStream(this.addresses);
            }
        };
    }

    public static DnsServerAddresses rotational(Iterable<? extends InetSocketAddress> iterable) {
        return DnsServerAddresses.rotational0(DnsServerAddresses.sanitize(iterable));
    }

    public static DnsServerAddresses rotational(InetSocketAddress ... inetSocketAddressArray) {
        return DnsServerAddresses.rotational0(DnsServerAddresses.sanitize(inetSocketAddressArray));
    }

    private static DnsServerAddresses rotational0(InetSocketAddress[] inetSocketAddressArray) {
        if (inetSocketAddressArray.length == 1) {
            return DnsServerAddresses.singleton(inetSocketAddressArray[0]);
        }
        return new RotationalDnsServerAddresses(inetSocketAddressArray);
    }

    public static DnsServerAddresses singleton(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            throw new NullPointerException("address");
        }
        if (inetSocketAddress.isUnresolved()) {
            throw new IllegalArgumentException("cannot use an unresolved DNS server address: " + inetSocketAddress);
        }
        return new SingletonDnsServerAddresses(inetSocketAddress);
    }

    private static InetSocketAddress[] sanitize(Iterable<? extends InetSocketAddress> iterable) {
        if (iterable == null) {
            throw new NullPointerException("addresses");
        }
        ArrayList<InetSocketAddress> arrayList = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<InetSocketAddress>(4);
        for (InetSocketAddress inetSocketAddress : iterable) {
            if (inetSocketAddress == null) break;
            if (inetSocketAddress.isUnresolved()) {
                throw new IllegalArgumentException("cannot use an unresolved DNS server address: " + inetSocketAddress);
            }
            arrayList.add(inetSocketAddress);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("empty addresses");
        }
        return arrayList.toArray(new InetSocketAddress[arrayList.size()]);
    }

    private static InetSocketAddress[] sanitize(InetSocketAddress[] inetSocketAddressArray) {
        if (inetSocketAddressArray == null) {
            throw new NullPointerException("addresses");
        }
        ArrayList<InetSocketAddress> arrayList = InternalThreadLocalMap.get().arrayList(inetSocketAddressArray.length);
        for (InetSocketAddress inetSocketAddress : inetSocketAddressArray) {
            if (inetSocketAddress == null) break;
            if (inetSocketAddress.isUnresolved()) {
                throw new IllegalArgumentException("cannot use an unresolved DNS server address: " + inetSocketAddress);
            }
            arrayList.add(inetSocketAddress);
        }
        if (arrayList.isEmpty()) {
            return DEFAULT_NAME_SERVER_ARRAY;
        }
        return arrayList.toArray(new InetSocketAddress[arrayList.size()]);
    }

    public abstract DnsServerAddressStream stream();

    static {
        int n = 53;
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(2);
        try {
            Class<?> clazz = Class.forName("sun.net.dns.ResolverConfiguration");
            Method method = clazz.getMethod("open", new Class[0]);
            Method method2 = clazz.getMethod("nameservers", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            List list = (List)method2.invoke(object, new Object[0]);
            for (String string : list) {
                if (string == null) continue;
                arrayList.add(new InetSocketAddress(InetAddress.getByName(string), 53));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!arrayList.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Default DNS servers: {} (sun.net.dns.ResolverConfiguration)", (Object)arrayList);
            }
        } else {
            Collections.addAll(arrayList, new InetSocketAddress("8.8.8.8", 53), new InetSocketAddress("8.8.4.4", 53));
            if (logger.isWarnEnabled()) {
                logger.warn("Default DNS servers: {} (Google Public DNS as a fallback)", (Object)arrayList);
            }
        }
        DEFAULT_NAME_SERVER_LIST = Collections.unmodifiableList(arrayList);
        DEFAULT_NAME_SERVER_ARRAY = arrayList.toArray(new InetSocketAddress[arrayList.size()]);
        DEFAULT_NAME_SERVERS = DnsServerAddresses.sequential(DEFAULT_NAME_SERVER_ARRAY);
    }
}

