/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.InetNameResolver;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsNameResolverContext;
import io.netty.resolver.dns.DnsQueryContext;
import io.netty.resolver.dns.DnsQueryContextManager;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DnsNameResolver
extends InetNameResolver {
    private static final InternalLogger logger;
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS;
    static final InternetProtocolFamily[] DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEACH_DOMAINS;
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final DnsServerAddresses nameServerAddresses;
    final Future<Channel> channelFuture;
    final DatagramChannel ch;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() throws Exception {
            return DnsNameResolver.this.nameServerAddresses.stream();
        }
    };
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final boolean traceEnabled;
    private final InternetProtocolFamily[] resolvedAddressTypes;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final String[] searchDomains;
    private final int ndots;

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddresses dnsServerAddresses, final DnsCache dnsCache, long l, InternetProtocolFamily[] internetProtocolFamilyArray, boolean bl, int n, boolean bl2, int n2, boolean bl3, HostsFileEntriesResolver hostsFileEntriesResolver, String[] stringArray, int n3) {
        super(eventLoop);
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        this.nameServerAddresses = ObjectUtil.checkNotNull(dnsServerAddresses, "nameServerAddresses");
        this.queryTimeoutMillis = ObjectUtil.checkPositive(l, "queryTimeoutMillis");
        this.resolvedAddressTypes = ObjectUtil.checkNonEmpty(internetProtocolFamilyArray, "resolvedAddressTypes");
        this.recursionDesired = bl;
        this.maxQueriesPerResolve = ObjectUtil.checkPositive(n, "maxQueriesPerResolve");
        this.traceEnabled = bl2;
        this.maxPayloadSize = ObjectUtil.checkPositive(n2, "maxPayloadSize");
        this.optResourceEnabled = bl3;
        this.hostsFileEntriesResolver = ObjectUtil.checkNotNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.resolveCache = dnsCache;
        this.searchDomains = (String[])ObjectUtil.checkNotNull(stringArray, "searchDomains").clone();
        this.ndots = ObjectUtil.checkPositiveOrZero(n3, "ndots");
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.executor());
        bootstrap.channelFactory(channelFactory);
        bootstrap.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        final DnsResponseHandler dnsResponseHandler = new DnsResponseHandler(this.executor().newPromise());
        bootstrap.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel datagramChannel) throws Exception {
                datagramChannel.pipeline().addLast(DECODER, ENCODER, dnsResponseHandler);
            }
        });
        this.channelFuture = dnsResponseHandler.channelActivePromise;
        this.ch = (DatagramChannel)bootstrap.register().channel();
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(n2));
        this.ch.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                dnsCache.clear();
            }
        });
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public List<InternetProtocolFamily> resolvedAddressTypes() {
        return Arrays.asList(this.resolvedAddressTypes);
    }

    InternetProtocolFamily[] resolveAddressTypesUnsafe() {
        return this.resolvedAddressTypes;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    @Override
    public void close() {
        this.ch.close();
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String string) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress inetAddress = this.hostsFileEntriesResolver.address(string);
        if (inetAddress == null && PlatformDependent.isWindows() && LOCALHOST.equalsIgnoreCase(string)) {
            return LOCALHOST_ADDRESS;
        }
        return inetAddress;
    }

    @Override
    protected void doResolve(String string, Promise<InetAddress> promise) throws Exception {
        this.doResolve(string, promise, this.resolveCache);
    }

    protected void doResolve(String string, Promise<InetAddress> promise, DnsCache dnsCache) throws Exception {
        byte[] byArray = NetUtil.createByteArrayFromIpAddressString(string);
        if (byArray != null) {
            promise.setSuccess(InetAddress.getByAddress(byArray));
            return;
        }
        String string2 = DnsNameResolver.hostname(string);
        InetAddress inetAddress = this.resolveHostsFileEntry(string2);
        if (inetAddress != null) {
            promise.setSuccess(inetAddress);
            return;
        }
        if (!this.doResolveCached(string2, promise, dnsCache)) {
            this.doResolveUncached(string2, promise, dnsCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveCached(String string, Promise<InetAddress> promise, DnsCache dnsCache) {
        List<DnsCacheEntry> list = dnsCache.get(string);
        if (list == null || list.isEmpty()) {
            return false;
        }
        InetAddress inetAddress = null;
        Throwable throwable = null;
        List<DnsCacheEntry> list2 = list;
        synchronized (list2) {
            int n = list.size();
            assert (n > 0);
            if (list.get(0).cause() != null) {
                throwable = list.get(0).cause();
            } else {
                block3: for (InternetProtocolFamily internetProtocolFamily : this.resolvedAddressTypes) {
                    for (int i = 0; i < n; ++i) {
                        DnsCacheEntry dnsCacheEntry = list.get(i);
                        if (!internetProtocolFamily.addressType().isInstance(dnsCacheEntry.address())) continue;
                        inetAddress = dnsCacheEntry.address();
                        continue block3;
                    }
                }
            }
        }
        if (inetAddress != null) {
            DnsNameResolver.setSuccess(promise, inetAddress);
        } else if (throwable != null) {
            if (!promise.tryFailure(throwable)) {
                logger.warn("Failed to notify failure to a promise: {}", (Object)promise, (Object)throwable);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void setSuccess(Promise<InetAddress> promise, InetAddress inetAddress) {
        if (!promise.trySuccess(inetAddress)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", (Object)inetAddress, (Object)promise);
        }
    }

    private void doResolveUncached(String string, Promise<InetAddress> promise, DnsCache dnsCache) {
        SingleResolverContext singleResolverContext = new SingleResolverContext(this, string, dnsCache);
        singleResolverContext.resolve(promise);
    }

    @Override
    protected void doResolveAll(String string, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(string, promise, this.resolveCache);
    }

    protected void doResolveAll(String string, Promise<List<InetAddress>> promise, DnsCache dnsCache) throws Exception {
        byte[] byArray = NetUtil.createByteArrayFromIpAddressString(string);
        if (byArray != null) {
            promise.setSuccess(Collections.singletonList(InetAddress.getByAddress(byArray)));
            return;
        }
        String string2 = DnsNameResolver.hostname(string);
        InetAddress inetAddress = this.resolveHostsFileEntry(string2);
        if (inetAddress != null) {
            promise.setSuccess(Collections.singletonList(inetAddress));
            return;
        }
        if (!this.doResolveAllCached(string2, promise, dnsCache)) {
            this.doResolveAllUncached(string2, promise, dnsCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveAllCached(String string, Promise<List<InetAddress>> promise, DnsCache dnsCache) {
        List<DnsCacheEntry> list = dnsCache.get(string);
        if (list == null || list.isEmpty()) {
            return false;
        }
        ArrayList<InetAddress> arrayList = null;
        Throwable throwable = null;
        List<DnsCacheEntry> list2 = list;
        synchronized (list2) {
            int n = list.size();
            assert (n > 0);
            if (list.get(0).cause() != null) {
                throwable = list.get(0).cause();
            } else {
                for (InternetProtocolFamily internetProtocolFamily : this.resolvedAddressTypes) {
                    for (int i = 0; i < n; ++i) {
                        DnsCacheEntry dnsCacheEntry = list.get(i);
                        if (!internetProtocolFamily.addressType().isInstance(dnsCacheEntry.address())) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<InetAddress>(n);
                        }
                        arrayList.add(dnsCacheEntry.address());
                    }
                }
            }
        }
        if (arrayList != null) {
            promise.trySuccess(arrayList);
        } else if (throwable != null) {
            promise.tryFailure(throwable);
        } else {
            return false;
        }
        return true;
    }

    private void doResolveAllUncached(String string, Promise<List<InetAddress>> promise, DnsCache dnsCache) {
        ListResolverContext listResolverContext = new ListResolverContext(this, string, dnsCache);
        listResolverContext.resolve(promise);
    }

    private static String hostname(String string) {
        String string2 = IDN.toASCII(string);
        if (StringUtil.endsWith(string, '.') && !StringUtil.endsWith(string2, '.')) {
            string2 = string2 + ".";
        }
        return string2;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion dnsQuestion) {
        return this.query(this.nextNameServerAddress(), dnsQuestion);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion dnsQuestion, Iterable<DnsRecord> iterable) {
        return this.query(this.nextNameServerAddress(), dnsQuestion, iterable);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion dnsQuestion, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), dnsQuestion, Collections.<DnsRecord>emptyList(), promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.nameServerAddrStream.get().next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion) {
        return this.query0(inetSocketAddress, dnsQuestion, Collections.<DnsRecord>emptyList(), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion, Iterable<DnsRecord> iterable) {
        return this.query0(inetSocketAddress, dnsQuestion, iterable, this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(inetSocketAddress, dnsQuestion, Collections.<DnsRecord>emptyList(), promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion, Iterable<DnsRecord> iterable, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(inetSocketAddress, dnsQuestion, iterable, promise);
    }

    private Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress inetSocketAddress, DnsQuestion dnsQuestion, Iterable<DnsRecord> iterable, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise2 = DnsNameResolver.cast(ObjectUtil.checkNotNull(promise, "promise"));
        try {
            new DnsQueryContext(this, inetSocketAddress, dnsQuestion, iterable, promise2).query();
            return promise2;
        }
        catch (Exception exception) {
            return promise2.setFailure(exception);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    static {
        String[] stringArray;
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[2];
        if (Boolean.getBoolean("java.net.preferIPv6Addresses")) {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv6;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv4;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
            logger.debug("-Djava.net.preferIPv6Addresses: true");
        } else {
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv4;
            DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv6;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
            logger.debug("-Djava.net.preferIPv6Addresses: false");
        }
        try {
            Class<?> clazz = Class.forName("sun.net.dns.ResolverConfiguration");
            Method method = clazz.getMethod("open", new Class[0]);
            Method method2 = clazz.getMethod("searchlist", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            List list = (List)method2.invoke(object, new Object[0]);
            stringArray = list.toArray(new String[list.size()]);
        }
        catch (Exception exception) {
            stringArray = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEACH_DOMAINS = stringArray;
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<Channel> channelActivePromise;

        DnsResponseHandler(Promise<Channel> promise) {
            this.channelActivePromise = promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            try {
                DnsQueryContext dnsQueryContext;
                DatagramDnsResponse datagramDnsResponse = (DatagramDnsResponse)object;
                int n = datagramDnsResponse.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, n, datagramDnsResponse.sender(), datagramDnsResponse);
                }
                if ((dnsQueryContext = DnsNameResolver.this.queryContextManager.get(datagramDnsResponse.sender(), n)) == null) {
                    logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)DnsNameResolver.this.ch, (Object)n);
                    return;
                }
                dnsQueryContext.finish(datagramDnsResponse);
            }
            finally {
                ReferenceCountUtil.safeRelease(object);
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            super.channelActive(channelHandlerContext);
            this.channelActivePromise.setSuccess(channelHandlerContext.channel());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            logger.warn("{} Unexpected exception: ", (Object)DnsNameResolver.this.ch, (Object)throwable);
        }
    }

    final class ListResolverContext
    extends DnsNameResolverContext<List<InetAddress>> {
        ListResolverContext(DnsNameResolver dnsNameResolver2, String string, DnsCache dnsCache) {
            super(dnsNameResolver2, string, dnsCache);
        }

        @Override
        DnsNameResolverContext<List<InetAddress>> newResolverContext(DnsNameResolver dnsNameResolver, String string, DnsCache dnsCache) {
            return new ListResolverContext(dnsNameResolver, string, dnsCache);
        }

        @Override
        boolean finishResolve(Class<? extends InetAddress> clazz, List<DnsCacheEntry> list, Promise<List<InetAddress>> promise) {
            ArrayList<InetAddress> arrayList = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                InetAddress inetAddress = list.get(i).address();
                if (!clazz.isInstance(inetAddress)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<InetAddress>(n);
                }
                arrayList.add(inetAddress);
            }
            if (arrayList != null) {
                promise.trySuccess(arrayList);
                return true;
            }
            return false;
        }
    }

    final class SingleResolverContext
    extends DnsNameResolverContext<InetAddress> {
        SingleResolverContext(DnsNameResolver dnsNameResolver2, String string, DnsCache dnsCache) {
            super(dnsNameResolver2, string, dnsCache);
        }

        @Override
        DnsNameResolverContext<InetAddress> newResolverContext(DnsNameResolver dnsNameResolver, String string, DnsCache dnsCache) {
            return new SingleResolverContext(dnsNameResolver, string, dnsCache);
        }

        @Override
        boolean finishResolve(Class<? extends InetAddress> clazz, List<DnsCacheEntry> list, Promise<InetAddress> promise) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                InetAddress inetAddress = list.get(i).address();
                if (!clazz.isInstance(inetAddress)) continue;
                DnsNameResolver.setSuccess(promise, inetAddress);
                return true;
            }
            return false;
        }
    }
}

