/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.EventLoop;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class DefaultDnsCache
implements DnsCache {
    private final ConcurrentMap<String, List<DnsCacheEntry>> resolveCache = PlatformDependent.newConcurrentHashMap();
    private final int minTtl;
    private final int maxTtl;
    private final int negativeTtl;

    public DefaultDnsCache() {
        this(0, Integer.MAX_VALUE, 0);
    }

    public DefaultDnsCache(int n, int n2, int n3) {
        this.minTtl = ObjectUtil.checkPositiveOrZero(n, "minTtl");
        this.maxTtl = ObjectUtil.checkPositiveOrZero(n2, "maxTtl");
        if (n > n2) {
            throw new IllegalArgumentException("minTtl: " + n + ", maxTtl: " + n2 + " (expected: 0 <= minTtl <= maxTtl)");
        }
        this.negativeTtl = ObjectUtil.checkPositiveOrZero(n3, "negativeTtl");
    }

    public int minTtl() {
        return this.minTtl;
    }

    public int maxTtl() {
        return this.maxTtl;
    }

    public int negativeTtl() {
        return this.negativeTtl;
    }

    @Override
    public void clear() {
        Iterator iterator = this.resolveCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            iterator.remove();
            DefaultDnsCache.cancelExpiration((List)entry.getValue());
        }
    }

    @Override
    public boolean clear(String string) {
        ObjectUtil.checkNotNull(string, "hostname");
        boolean bl = false;
        Iterator iterator = this.resolveCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).equals(string)) continue;
            iterator.remove();
            DefaultDnsCache.cancelExpiration((List)entry.getValue());
            bl = true;
        }
        return bl;
    }

    @Override
    public List<DnsCacheEntry> get(String string) {
        ObjectUtil.checkNotNull(string, "hostname");
        return (List)this.resolveCache.get(string);
    }

    private List<DnsCacheEntry> cachedEntries(String string) {
        ArrayList arrayList;
        ArrayList arrayList2 = (ArrayList)this.resolveCache.get(string);
        ArrayList arrayList3 = arrayList2 == null ? ((arrayList2 = (List)this.resolveCache.putIfAbsent(string, arrayList = new ArrayList(8))) != null ? arrayList2 : arrayList) : arrayList2;
        return arrayList3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(String string, InetAddress inetAddress, long l, EventLoop eventLoop) {
        if (this.maxTtl == 0) {
            return;
        }
        ObjectUtil.checkNotNull(string, "hostname");
        ObjectUtil.checkNotNull(inetAddress, "address");
        ObjectUtil.checkNotNull(eventLoop, "loop");
        int n = Math.max(this.minTtl, (int)Math.min((long)this.maxTtl, l));
        List<DnsCacheEntry> list = this.cachedEntries(string);
        DnsCacheEntry dnsCacheEntry = new DnsCacheEntry(string, inetAddress);
        List<DnsCacheEntry> list2 = list;
        synchronized (list2) {
            DnsCacheEntry dnsCacheEntry2;
            if (!list.isEmpty() && (dnsCacheEntry2 = list.get(0)).cause() != null) {
                assert (list.size() == 1);
                dnsCacheEntry2.cancelExpiration();
                list.clear();
            }
            list.add(dnsCacheEntry);
        }
        this.scheduleCacheExpiration(list, dnsCacheEntry, n, eventLoop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(String string, Throwable throwable, EventLoop eventLoop) {
        if (this.negativeTtl == 0) {
            return;
        }
        ObjectUtil.checkNotNull(string, "hostname");
        ObjectUtil.checkNotNull(throwable, "cause");
        ObjectUtil.checkNotNull(eventLoop, "loop");
        List<DnsCacheEntry> list = this.cachedEntries(string);
        DnsCacheEntry dnsCacheEntry = new DnsCacheEntry(string, throwable);
        List<DnsCacheEntry> list2 = list;
        synchronized (list2) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).cancelExpiration();
            }
            list.clear();
            list.add(dnsCacheEntry);
        }
        this.scheduleCacheExpiration(list, dnsCacheEntry, this.negativeTtl, eventLoop);
    }

    private static void cancelExpiration(List<DnsCacheEntry> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).cancelExpiration();
        }
    }

    private void scheduleCacheExpiration(final List<DnsCacheEntry> list, final DnsCacheEntry dnsCacheEntry, int n, EventLoop eventLoop) {
        dnsCacheEntry.scheduleExpiration(eventLoop, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list2 = list;
                synchronized (list2) {
                    list.remove(dnsCacheEntry);
                    if (list.isEmpty()) {
                        DefaultDnsCache.this.resolveCache.remove(dnsCacheEntry.hostname());
                    }
                }
            }
        }, n, TimeUnit.SECONDS);
    }

    public String toString() {
        return "DefaultDnsCache(minTtl=" + this.minTtl + ", maxTtl=" + this.maxTtl + ", negativeTtl=" + this.negativeTtl + ", cached resolved hostname=" + this.resolveCache.size() + ")";
    }
}

