/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import java.security.cert.CertificateException;

public final class OpenSslCertificateException
extends CertificateException {
    private static final long serialVersionUID = 5542675253797129798L;
    private final int errorCode;

    public OpenSslCertificateException(int n) {
        this((String)null, n);
    }

    public OpenSslCertificateException(String string, int n) {
        super(string);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n);
    }

    public OpenSslCertificateException(String string, Throwable throwable, int n) {
        super(string, throwable);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n);
    }

    public OpenSslCertificateException(Throwable throwable, int n) {
        this(null, throwable, n);
    }

    public int errorCode() {
        return this.errorCode;
    }

    private static int checkErrorCode(int n) {
        if (n < 0 || n > 65) {
            throw new IllegalArgumentException("errorCode must be 0 => 65. See https://www.openssl.org/docs/manmaster/apps/verify.html .");
        }
        return n;
    }
}

