/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import java.util.List;

public class Socks5PasswordAuthResponseDecoder
extends ReplayingDecoder<State> {
    public Socks5PasswordAuthResponseDecoder() {
        super(State.INIT);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case INIT: {
                    int n = byteBuf.readByte();
                    if (n != 1) {
                        throw new DecoderException("unsupported subnegotiation version: " + n + " (expected: 1)");
                    }
                    list.add(new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.valueOf(byteBuf.readByte())));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int n = this.actualReadableBytes();
                    if (n <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Throwable throwable) {
        if (!(throwable instanceof DecoderException)) {
            throwable = new DecoderException(throwable);
        }
        this.checkpoint(State.FAILURE);
        DefaultSocks5PasswordAuthResponse defaultSocks5PasswordAuthResponse = new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE);
        defaultSocks5PasswordAuthResponse.setDecoderResult(DecoderResult.failure(throwable));
        list.add(defaultSocks5PasswordAuthResponse);
    }

    static enum State {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

