/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.memcache.LastMemcacheContent;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestEncoder;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponseDecoder;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public final class BinaryMemcacheClientCodec
extends CombinedChannelDuplexHandler<BinaryMemcacheResponseDecoder, BinaryMemcacheRequestEncoder> {
    private final boolean failOnMissingResponse;
    private final AtomicLong requestResponseCounter = new AtomicLong();

    public BinaryMemcacheClientCodec() {
        this(8192);
    }

    public BinaryMemcacheClientCodec(int n) {
        this(n, false);
    }

    public BinaryMemcacheClientCodec(int n, boolean bl) {
        this.failOnMissingResponse = bl;
        this.init(new Decoder(n), new Encoder());
    }

    private final class Decoder
    extends BinaryMemcacheResponseDecoder {
        Decoder(int n) {
            super(n);
        }

        @Override
        protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
            int n = list.size();
            super.decode(channelHandlerContext, byteBuf, list);
            if (BinaryMemcacheClientCodec.this.failOnMissingResponse) {
                int n2 = list.size();
                for (int i = n; i < n2; ++i) {
                    Object object = list.get(i);
                    if (!(object instanceof LastMemcacheContent)) continue;
                    BinaryMemcacheClientCodec.this.requestResponseCounter.decrementAndGet();
                }
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            long l;
            super.channelInactive(channelHandlerContext);
            if (BinaryMemcacheClientCodec.this.failOnMissingResponse && (l = BinaryMemcacheClientCodec.this.requestResponseCounter.get()) > 0L) {
                channelHandlerContext.fireExceptionCaught(new PrematureChannelClosureException("channel gone inactive with " + l + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends BinaryMemcacheRequestEncoder {
        private Encoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
            super.encode(channelHandlerContext, object, list);
            if (BinaryMemcacheClientCodec.this.failOnMissingResponse && object instanceof LastMemcacheContent) {
                BinaryMemcacheClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

