/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;

final class HuffmanDecoder {
    private static final IOException EOS_DECODED = ThrowableUtil.unknownStackTrace(new IOException("HPACK - EOS Decoded"), HuffmanDecoder.class, "decode(...)");
    private static final IOException INVALID_PADDING = ThrowableUtil.unknownStackTrace(new IOException("HPACK - Invalid Padding"), HuffmanDecoder.class, "decode(...)");
    private static final Node ROOT = HuffmanDecoder.buildTree(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    private final DecoderProcessor processor;

    HuffmanDecoder(int n) {
        this.processor = new DecoderProcessor(n);
    }

    public AsciiString decode(ByteBuf byteBuf, int n) throws IOException {
        this.processor.reset();
        byteBuf.forEachByte(byteBuf.readerIndex(), n, this.processor);
        byteBuf.skipBytes(n);
        return this.processor.end();
    }

    private static Node buildTree(int[] nArray, byte[] byArray) {
        Node node = new Node();
        for (int i = 0; i < nArray.length; ++i) {
            HuffmanDecoder.insert(node, i, nArray[i], byArray[i]);
        }
        return node;
    }

    private static void insert(Node node, int n, int n2, byte by) {
        Node node2 = node;
        while (by > 8) {
            if (node2.isTerminal()) {
                throw new IllegalStateException("invalid Huffman code: prefix not unique");
            }
            by = (byte)(by - 8);
            int n3 = n2 >>> by & 0xFF;
            if (node2.children[n3] == null) {
                ((Node)node2).children[n3] = new Node();
            }
            node2 = node2.children[n3];
        }
        Node node3 = new Node(n, by);
        int n4 = 8 - by;
        int n5 = n2 << n4 & 0xFF;
        int n6 = 1 << n4;
        for (int i = n5; i < n5 + n6; ++i) {
            ((Node)node2).children[i] = node3;
        }
    }

    private static final class DecoderProcessor
    implements ByteProcessor {
        private final int initialCapacity;
        private byte[] bytes;
        private int index;
        private Node node;
        private int current;
        private int currentBits;
        private int symbolBits;

        DecoderProcessor(int n) {
            this.initialCapacity = ObjectUtil.checkPositive(n, "initialCapacity");
        }

        void reset() {
            this.node = ROOT;
            this.current = 0;
            this.currentBits = 0;
            this.symbolBits = 0;
            this.bytes = new byte[this.initialCapacity];
            this.index = 0;
        }

        @Override
        public boolean process(byte by) throws IOException {
            this.current = this.current << 8 | by & 0xFF;
            this.currentBits += 8;
            this.symbolBits += 8;
            do {
                this.node = this.node.children[this.current >>> this.currentBits - 8 & 0xFF];
                this.currentBits -= this.node.bits;
                if (!this.node.isTerminal()) continue;
                if (this.node.symbol == 256) {
                    throw EOS_DECODED;
                }
                this.append(this.node.symbol);
                this.node = ROOT;
                this.symbolBits = this.currentBits;
            } while (this.currentBits >= 8);
            return true;
        }

        AsciiString end() throws IOException {
            while (this.currentBits > 0) {
                this.node = this.node.children[this.current << 8 - this.currentBits & 0xFF];
                if (!this.node.isTerminal() || this.node.bits > this.currentBits) break;
                if (this.node.symbol == 256) {
                    throw EOS_DECODED;
                }
                this.currentBits -= this.node.bits;
                this.append(this.node.symbol);
                this.node = ROOT;
                this.symbolBits = this.currentBits;
            }
            int n = (1 << this.symbolBits) - 1;
            if (this.symbolBits > 7 || (this.current & n) != n) {
                throw INVALID_PADDING;
            }
            return new AsciiString(this.bytes, 0, this.index, false);
        }

        private void append(int n) {
            try {
                this.bytes[this.index] = (byte)n;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                byte[] byArray = new byte[this.bytes.length + this.initialCapacity];
                System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
                this.bytes = byArray;
                this.bytes[this.index] = (byte)n;
            }
            ++this.index;
        }
    }

    private static final class Node {
        private final int symbol;
        private final int bits;
        private final Node[] children;

        Node() {
            this.symbol = 0;
            this.bits = 8;
            this.children = new Node[256];
        }

        Node(int n, int n2) {
            assert (n2 > 0 && n2 <= 8);
            this.symbol = n;
            this.bits = n2;
            this.children = null;
        }

        private boolean isTerminal() {
            return this.children == null;
        }
    }
}

