/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.internal.hpack.DynamicTable;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanDecoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;

public final class Decoder {
    private static final IOException DECODE_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(new IOException("HPACK - decompression failure"), Decoder.class, "decode(...)");
    private static final IOException DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(new IOException("HPACK - decompression failure"), Decoder.class, "decodeULE128(...)");
    private static final IOException DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "decode(...)");
    private static final IOException INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "indexHeader(...)");
    private static final IOException READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - illegal index value"), Decoder.class, "readName(...)");
    private static final IOException INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(new IOException("HPACK - invalid max dynamic table size"), Decoder.class, "setDynamicTableSize(...)");
    private static final IOException MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(new IOException("HPACK - max dynamic table size change required"), Decoder.class, "decode(...)");
    private final DynamicTable dynamicTable;
    private final HuffmanDecoder huffmanDecoder;
    private final int maxHeaderSize;
    private int maxDynamicTableSize;
    private int encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;
    private long headerSize;
    private State state;
    private HpackUtil.IndexType indexType;
    private int index;
    private boolean huffmanEncoded;
    private int skipLength;
    private int nameLength;
    private int valueLength;
    private CharSequence name;

    public Decoder(int n, int n2, int n3) {
        this.dynamicTable = new DynamicTable(n2);
        this.maxHeaderSize = n;
        this.maxDynamicTableSize = n2;
        this.encoderMaxDynamicTableSize = n2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.huffmanDecoder = new HuffmanDecoder(n3);
        this.reset();
    }

    private void reset() {
        this.headerSize = 0L;
        this.state = State.READ_HEADER_REPRESENTATION;
        this.indexType = HpackUtil.IndexType.NONE;
    }

    public void decode(ByteBuf byteBuf, Http2Headers http2Headers) throws IOException {
        block14: while (byteBuf.isReadable()) {
            switch (this.state) {
                case READ_HEADER_REPRESENTATION: {
                    byte by = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (by & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (by < 0) {
                        this.index = by & 0x7F;
                        if (this.index == 0) {
                            throw DECODE_ILLEGAL_INDEX_VALUE;
                        }
                        if (this.index == 127) {
                            this.state = State.READ_INDEXED_HEADER;
                            continue block14;
                        }
                        this.indexHeader(this.index, http2Headers);
                        continue block14;
                    }
                    if ((by & 0x40) == 64) {
                        this.indexType = HpackUtil.IndexType.INCREMENTAL;
                        this.index = by & 0x3F;
                        if (this.index == 0) {
                            this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                            continue block14;
                        }
                        if (this.index == 63) {
                            this.state = State.READ_INDEXED_HEADER_NAME;
                            continue block14;
                        }
                        this.readName(this.index);
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                        continue block14;
                    }
                    if ((by & 0x20) == 32) {
                        this.index = by & 0x1F;
                        if (this.index == 31) {
                            this.state = State.READ_MAX_DYNAMIC_TABLE_SIZE;
                            continue block14;
                        }
                        this.setDynamicTableSize(this.index);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.indexType = (by & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    this.index = by & 0xF;
                    if (this.index == 0) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH_PREFIX;
                        continue block14;
                    }
                    if (this.index == 15) {
                        this.state = State.READ_INDEXED_HEADER_NAME;
                        continue block14;
                    }
                    this.readName(this.index);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_MAX_DYNAMIC_TABLE_SIZE: {
                    int n = Decoder.decodeULE128(byteBuf);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.setDynamicTableSize(this.index + n);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER: {
                    int n = Decoder.decodeULE128(byteBuf);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.indexHeader(this.index + n, http2Headers);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case READ_INDEXED_HEADER_NAME: {
                    int n = Decoder.decodeULE128(byteBuf);
                    if (n == -1) {
                        return;
                    }
                    if (n > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.readName(this.index + n);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH_PREFIX: {
                    byte by = byteBuf.readByte();
                    this.huffmanEncoded = (by & 0x80) == 128;
                    this.index = by & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_NAME_LENGTH;
                        continue block14;
                    }
                    this.nameLength = this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME_LENGTH: {
                    this.nameLength = Decoder.decodeULE128(byteBuf);
                    if (this.nameLength == -1) {
                        return;
                    }
                    if (this.nameLength > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.nameLength += this.index;
                    if (this.exceedsMaxHeaderSize(this.nameLength)) {
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                        if (this.nameLength + 32 > this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.name = AsciiString.EMPTY_STRING;
                            this.skipLength = this.nameLength;
                            this.state = State.SKIP_LITERAL_HEADER_NAME;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_NAME;
                    continue block14;
                }
                case READ_LITERAL_HEADER_NAME: {
                    if (byteBuf.readableBytes() < this.nameLength) {
                        return;
                    }
                    this.name = this.readStringLiteral(byteBuf, this.nameLength);
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_NAME: {
                    int n = Math.min(byteBuf.readableBytes(), this.skipLength);
                    byteBuf.skipBytes(n);
                    this.skipLength -= n;
                    if (this.skipLength != 0) continue block14;
                    this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX: {
                    byte by = byteBuf.readByte();
                    this.huffmanEncoded = (by & 0x80) == 128;
                    this.index = by & 0x7F;
                    if (this.index == 127) {
                        this.state = State.READ_LITERAL_HEADER_VALUE_LENGTH;
                        continue block14;
                    }
                    this.valueLength = this.index;
                    long l = (long)this.nameLength + (long)this.valueLength;
                    if (this.exceedsMaxHeaderSize(l)) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (l + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    if (this.valueLength == 0) {
                        this.insertHeader(http2Headers, this.name, AsciiString.EMPTY_STRING, this.indexType);
                        this.state = State.READ_HEADER_REPRESENTATION;
                        continue block14;
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE_LENGTH: {
                    this.valueLength = Decoder.decodeULE128(byteBuf);
                    if (this.valueLength == -1) {
                        return;
                    }
                    if (this.valueLength > Integer.MAX_VALUE - this.index) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.valueLength += this.index;
                    long l = (long)this.nameLength + (long)this.valueLength;
                    if (l + this.headerSize > (long)this.maxHeaderSize) {
                        this.headerSize = this.maxHeaderSize + 1;
                        if (this.indexType == HpackUtil.IndexType.NONE) {
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                        if (l + 32L > (long)this.dynamicTable.capacity()) {
                            this.dynamicTable.clear();
                            this.state = State.SKIP_LITERAL_HEADER_VALUE;
                            continue block14;
                        }
                    }
                    this.state = State.READ_LITERAL_HEADER_VALUE;
                    continue block14;
                }
                case READ_LITERAL_HEADER_VALUE: {
                    if (byteBuf.readableBytes() < this.valueLength) {
                        return;
                    }
                    CharSequence charSequence = this.readStringLiteral(byteBuf, this.valueLength);
                    this.insertHeader(http2Headers, this.name, charSequence, this.indexType);
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
                case SKIP_LITERAL_HEADER_VALUE: {
                    int n = Math.min(byteBuf.readableBytes(), this.valueLength);
                    byteBuf.skipBytes(n);
                    this.valueLength -= n;
                    if (this.valueLength != 0) continue block14;
                    this.state = State.READ_HEADER_REPRESENTATION;
                    continue block14;
                }
            }
            throw new IllegalStateException("should not reach here");
        }
    }

    public boolean endHeaderBlock() {
        boolean bl = this.headerSize > (long)this.maxHeaderSize;
        this.reset();
        return bl;
    }

    public void setMaxHeaderTableSize(int n) {
        this.maxDynamicTableSize = n;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.dynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public int getMaxHeaderTableSize() {
        return this.dynamicTable.capacity();
    }

    int length() {
        return this.dynamicTable.length();
    }

    int size() {
        return this.dynamicTable.size();
    }

    HeaderField getHeaderField(int n) {
        return this.dynamicTable.getEntry(n + 1);
    }

    private void setDynamicTableSize(int n) throws IOException {
        if (n > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = n;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable.setCapacity(n);
    }

    private void readName(int n) throws IOException {
        if (n <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(n);
            this.name = headerField.name;
        } else if (n - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(n - StaticTable.length);
            this.name = headerField.name;
        } else {
            throw READ_NAME_ILLEGAL_INDEX_VALUE;
        }
    }

    private void indexHeader(int n, Http2Headers http2Headers) throws IOException {
        if (n <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(n);
            this.addHeader(http2Headers, headerField.name, headerField.value);
        } else if (n - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(n - StaticTable.length);
            this.addHeader(http2Headers, headerField.name, headerField.value);
        } else {
            throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
        }
    }

    private void insertHeader(Http2Headers http2Headers, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType) {
        this.addHeader(http2Headers, charSequence, charSequence2);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.dynamicTable.add(new HeaderField(charSequence, charSequence2));
                break;
            }
            default: {
                throw new IllegalStateException("should not reach here");
            }
        }
    }

    private void addHeader(Http2Headers http2Headers, CharSequence charSequence, CharSequence charSequence2) {
        long l = this.headerSize + (long)charSequence.length() + (long)charSequence2.length();
        if (l <= (long)this.maxHeaderSize) {
            http2Headers.add(charSequence, charSequence2);
            this.headerSize = (int)l;
        } else {
            this.headerSize = this.maxHeaderSize + 1;
        }
    }

    private boolean exceedsMaxHeaderSize(long l) {
        if (l + this.headerSize <= (long)this.maxHeaderSize) {
            return false;
        }
        this.headerSize = this.maxHeaderSize + 1;
        return true;
    }

    private CharSequence readStringLiteral(ByteBuf byteBuf, int n) throws IOException {
        if (this.huffmanEncoded) {
            return this.huffmanDecoder.decode(byteBuf, n);
        }
        byte[] byArray = new byte[n];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static int decodeULE128(ByteBuf byteBuf) throws IOException {
        byteBuf.markReaderIndex();
        int n = 0;
        for (int i = 0; i < 32; i += 7) {
            if (!byteBuf.isReadable()) {
                byteBuf.resetReaderIndex();
                return -1;
            }
            byte by = byteBuf.readByte();
            if (i == 28 && (by & 0xF8) != 0) break;
            n |= (by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return n;
        }
        byteBuf.resetReaderIndex();
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }

    private static enum State {
        READ_HEADER_REPRESENTATION,
        READ_MAX_DYNAMIC_TABLE_SIZE,
        READ_INDEXED_HEADER,
        READ_INDEXED_HEADER_NAME,
        READ_LITERAL_HEADER_NAME_LENGTH_PREFIX,
        READ_LITERAL_HEADER_NAME_LENGTH,
        READ_LITERAL_HEADER_NAME,
        SKIP_LITERAL_HEADER_NAME,
        READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX,
        READ_LITERAL_HEADER_VALUE_LENGTH,
        READ_LITERAL_HEADER_VALUE,
        SKIP_LITERAL_HEADER_VALUE;

    }
}

