/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public final class InboundHttp2ToHttpPriorityAdapter
extends InboundHttp2ToHttpAdapter {
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_METHOD = new AsciiString(HttpConversionUtil.OUT_OF_MESSAGE_SEQUENCE_METHOD.toString());
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_PATH = new AsciiString("");
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = new AsciiString(HttpConversionUtil.OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE.toString());
    private final Http2Connection.PropertyKey outOfMessageFlowHeadersKey;

    InboundHttp2ToHttpPriorityAdapter(Http2Connection http2Connection, int n, boolean bl, boolean bl2) {
        super(http2Connection, n, bl, bl2);
        this.outOfMessageFlowHeadersKey = http2Connection.newKey();
    }

    private HttpHeaders getOutOfMessageFlowHeaders(Http2Stream http2Stream) {
        return (HttpHeaders)http2Stream.getProperty(this.outOfMessageFlowHeadersKey);
    }

    private void putOutOfMessageFlowHeaders(Http2Stream http2Stream, HttpHeaders httpHeaders) {
        http2Stream.setProperty(this.outOfMessageFlowHeadersKey, httpHeaders);
    }

    private HttpHeaders removeOutOfMessageFlowHeaders(Http2Stream http2Stream) {
        return (HttpHeaders)http2Stream.removeProperty(this.outOfMessageFlowHeadersKey);
    }

    private static HttpHeaders getActiveHeaders(FullHttpMessage fullHttpMessage) {
        return fullHttpMessage.content().isReadable() ? fullHttpMessage.trailingHeaders() : fullHttpMessage.headers();
    }

    private void importOutOfMessageFlowHeaders(Http2Stream http2Stream, HttpHeaders httpHeaders) {
        HttpHeaders httpHeaders2 = this.getOutOfMessageFlowHeaders(http2Stream);
        if (httpHeaders2 == null) {
            this.putOutOfMessageFlowHeaders(http2Stream, httpHeaders);
        } else {
            httpHeaders2.setAll(httpHeaders);
        }
    }

    private void exportOutOfMessageFlowHeaders(Http2Stream http2Stream, HttpHeaders httpHeaders) {
        HttpHeaders httpHeaders2 = this.getOutOfMessageFlowHeaders(http2Stream);
        if (httpHeaders2 != null) {
            httpHeaders.setAll(httpHeaders2);
        }
    }

    private static void removePriorityRelatedHeaders(HttpHeaders httpHeaders) {
        httpHeaders.remove(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text());
        httpHeaders.remove(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text());
    }

    private void initializePseudoHeaders(Http2Headers http2Headers) {
        if (this.connection.isServer()) {
            http2Headers.method(OUT_OF_MESSAGE_SEQUENCE_METHOD).path(OUT_OF_MESSAGE_SEQUENCE_PATH);
        } else {
            http2Headers.status(OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE);
        }
    }

    private static void addHttpHeadersToHttp2Headers(HttpHeaders httpHeaders, Http2Headers http2Headers) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = httpHeaders.iteratorCharSequence();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, CharSequence> entry = iterator.next();
            http2Headers.add(AsciiString.of(entry.getKey()), AsciiString.of(entry.getValue()));
        }
    }

    @Override
    protected void fireChannelRead(ChannelHandlerContext channelHandlerContext, FullHttpMessage fullHttpMessage, boolean bl, Http2Stream http2Stream) {
        this.exportOutOfMessageFlowHeaders(http2Stream, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(fullHttpMessage));
        super.fireChannelRead(channelHandlerContext, fullHttpMessage, bl, http2Stream);
    }

    @Override
    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, Http2Headers http2Headers, boolean bl, boolean bl2, boolean bl3) throws Http2Exception {
        FullHttpMessage fullHttpMessage = super.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, bl, bl2, bl3);
        if (fullHttpMessage != null) {
            this.exportOutOfMessageFlowHeaders(http2Stream, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(fullHttpMessage));
        }
        return fullHttpMessage;
    }

    @Override
    public void onPriorityTreeParentChanged(Http2Stream http2Stream, Http2Stream http2Stream2) {
        Http2Stream http2Stream3 = http2Stream.parent();
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage == null) {
            if (http2Stream3 != null && !http2Stream3.equals(this.connection.connectionStream())) {
                DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders();
                ((HttpHeaders)defaultHttpHeaders).setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), http2Stream3.id());
                this.importOutOfMessageFlowHeaders(http2Stream, defaultHttpHeaders);
            }
        } else if (http2Stream3 == null) {
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(fullHttpMessage.headers());
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(fullHttpMessage.trailingHeaders());
        } else if (!http2Stream3.equals(this.connection.connectionStream())) {
            HttpHeaders httpHeaders = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(fullHttpMessage);
            httpHeaders.setInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), http2Stream3.id());
        }
    }

    @Override
    public void onWeightChanged(Http2Stream http2Stream, short s) {
        HttpHeaders httpHeaders;
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage == null) {
            httpHeaders = new DefaultHttpHeaders();
            this.importOutOfMessageFlowHeaders(http2Stream, httpHeaders);
        } else {
            httpHeaders = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(fullHttpMessage);
        }
        httpHeaders.setShort(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), http2Stream.weight());
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) throws Http2Exception {
        Http2Stream http2Stream = this.connection.stream(n);
        if (http2Stream == null) {
            return;
        }
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage == null) {
            HttpHeaders httpHeaders = this.removeOutOfMessageFlowHeaders(http2Stream);
            if (httpHeaders == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Priority Frame recieved for unknown stream id %d", n);
            }
            DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(this.validateHttpHeaders, httpHeaders.size());
            this.initializePseudoHeaders(defaultHttp2Headers);
            InboundHttp2ToHttpPriorityAdapter.addHttpHeadersToHttp2Headers(httpHeaders, defaultHttp2Headers);
            fullHttpMessage = this.newMessage(http2Stream, defaultHttp2Headers, this.validateHttpHeaders, channelHandlerContext.alloc());
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, false, http2Stream);
        }
    }
}

