/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.util.internal.ObjectUtil;

public final class DefaultHttp2ResetFrame
extends AbstractHttp2StreamFrame
implements Http2ResetFrame {
    private final long errorCode;

    public DefaultHttp2ResetFrame(Http2Error http2Error) {
        this.errorCode = ObjectUtil.checkNotNull(http2Error, "error").code();
    }

    public DefaultHttp2ResetFrame(long l) {
        this.errorCode = l;
    }

    @Override
    public DefaultHttp2ResetFrame setStreamId(int n) {
        super.setStreamId(n);
        return this;
    }

    @Override
    public String name() {
        return "RST_STREAM";
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    public String toString() {
        return "DefaultHttp2ResetFrame(stream=" + this.streamId() + "errorCode=" + this.errorCode + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2ResetFrame)) {
            return false;
        }
        DefaultHttp2ResetFrame defaultHttp2ResetFrame = (DefaultHttp2ResetFrame)object;
        return super.equals(object) && this.errorCode == defaultHttp2ResetFrame.errorCode;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = n * 31 + (int)(this.errorCode ^ this.errorCode >>> 32);
        return n;
    }
}

