/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

abstract class AbstractHttp2StreamChannel
extends AbstractChannel {
    protected static final Object CLOSE_MESSAGE = new Object();
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractHttp2StreamChannel.class, "doWrite(...)");
    private static final int ARBITRARY_MESSAGE_SIZE = 9;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>(4);
    private final Runnable fireChildReadCompleteTask = new Runnable(){

        @Override
        public void run() {
            if (AbstractHttp2StreamChannel.this.readInProgress) {
                AbstractHttp2StreamChannel.this.readInProgress = false;
                AbstractHttp2StreamChannel.this.unsafe().recvBufAllocHandle().readComplete();
                AbstractHttp2StreamChannel.this.pipeline().fireChannelReadComplete();
            }
        }
    };
    private boolean closed;
    private boolean readInProgress;

    public AbstractHttp2StreamChannel(Channel channel) {
        super(channel);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isActive() {
        return !this.closed;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new Unsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return true;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.parent().remoteAddress();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doClose() throws Exception {
        this.closed = true;
        while (!this.inboundBuffer.isEmpty()) {
            ReferenceCountUtil.release(this.inboundBuffer.poll());
        }
    }

    @Override
    protected void doBeginRead() {
        Object object;
        if (this.readInProgress) {
            return;
        }
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        if (this.inboundBuffer.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        while ((object = this.inboundBuffer.poll()) != null) {
            if (!this.doRead0(object, handle)) {
                return;
            }
            if (handle.continueReading()) continue;
        }
        handle.readComplete();
        this.pipeline().fireChannelReadComplete();
    }

    @Override
    protected final void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        if (this.closed) {
            throw CLOSED_CHANNEL_EXCEPTION;
        }
        EventExecutor eventExecutor = this.preferredEventExecutor();
        if (eventExecutor.inEventLoop()) {
            Object object;
            while ((object = channelOutboundBuffer.current()) != null) {
                try {
                    this.doWrite(ReferenceCountUtil.retain(object));
                }
                catch (Throwable throwable) {
                    this.pipeline().fireExceptionCaught(throwable);
                }
                channelOutboundBuffer.remove();
            }
            this.doWriteComplete();
        } else {
            final Object[] objectArray = new Object[channelOutboundBuffer.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = ReferenceCountUtil.retain(channelOutboundBuffer.current());
                channelOutboundBuffer.remove();
            }
            eventExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    for (Object object : objectArray) {
                        try {
                            AbstractHttp2StreamChannel.this.doWrite(object);
                        }
                        catch (Throwable throwable) {
                            AbstractHttp2StreamChannel.this.pipeline().fireExceptionCaught(throwable);
                        }
                    }
                    AbstractHttp2StreamChannel.this.doWriteComplete();
                }
            });
        }
    }

    protected abstract void doWrite(Object var1) throws Exception;

    protected abstract void doWriteComplete();

    protected abstract EventExecutor preferredEventExecutor();

    protected abstract void bytesConsumed(int var1);

    protected void fireChildRead(final Object object) {
        if (this.eventLoop().inEventLoop()) {
            this.fireChildRead0(object);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractHttp2StreamChannel.this.fireChildRead0(object);
                }
            });
        }
    }

    private void fireChildRead0(Object object) {
        if (this.closed) {
            ReferenceCountUtil.release(object);
            return;
        }
        if (this.readInProgress) {
            assert (this.inboundBuffer.isEmpty());
            RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
            this.readInProgress = this.doRead0(ObjectUtil.checkNotNull(object, "msg"), handle);
            if (!handle.continueReading()) {
                this.fireChildReadCompleteTask.run();
            }
        } else {
            this.inboundBuffer.add(object);
        }
    }

    protected void fireChildReadComplete() {
        if (this.eventLoop().inEventLoop()) {
            this.fireChildReadCompleteTask.run();
        } else {
            this.eventLoop().execute(this.fireChildReadCompleteTask);
        }
    }

    private boolean doRead0(Object object, RecvByteBufAllocator.Handle handle) {
        if (object == CLOSE_MESSAGE) {
            handle.readComplete();
            this.pipeline().fireChannelReadComplete();
            this.unsafe().close(this.voidPromise());
            return false;
        }
        int n = 0;
        if (object instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)object;
            n = http2DataFrame.content().readableBytes() + http2DataFrame.padding();
            handle.lastBytesRead(n);
        } else {
            handle.lastBytesRead(9);
        }
        handle.incMessagesRead(1);
        this.pipeline().fireChannelRead(object);
        if (n != 0) {
            this.bytesConsumed(n);
        }
        return true;
    }

    private final class Unsafe
    extends AbstractChannel.AbstractUnsafe {
        private Unsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            channelPromise.setFailure(new UnsupportedOperationException());
        }
    }
}

