/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.ComposedLastHttpContent;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private static final int CONTINUE_CODE = HttpResponseStatus.CONTINUE.code();
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private CharSequence acceptEncoding;
    private EmbeddedChannel encoder;
    private State state = State.AWAIT_HEADERS;

    @Override
    public boolean acceptOutboundMessage(Object object) throws Exception {
        return object instanceof HttpContent || object instanceof HttpResponse;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, List<Object> list) throws Exception {
        HttpMethod httpMethod;
        CharSequence charSequence = httpRequest.headers().get(HttpHeaderNames.ACCEPT_ENCODING);
        if (charSequence == null) {
            charSequence = HttpContentDecoder.IDENTITY;
        }
        if ((httpMethod = httpRequest.method()) == HttpMethod.HEAD) {
            charSequence = ZERO_LENGTH_HEAD;
        } else if (httpMethod == HttpMethod.CONNECT) {
            charSequence = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add(charSequence);
        list.add(ReferenceCountUtil.retain(httpRequest));
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) throws Exception {
        boolean bl = httpObject instanceof HttpResponse && httpObject instanceof LastHttpContent;
        switch (this.state) {
            case AWAIT_HEADERS: {
                HttpContentEncoder.ensureHeaders(httpObject);
                assert (this.encoder == null);
                HttpResponse httpResponse = (HttpResponse)httpObject;
                int n = httpResponse.status().code();
                if (n == CONTINUE_CODE) {
                    this.acceptEncoding = null;
                } else {
                    this.acceptEncoding = this.acceptEncodingQueue.poll();
                    if (this.acceptEncoding == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(httpResponse.protocolVersion(), n, this.acceptEncoding)) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        break;
                    }
                    list.add(httpResponse);
                    this.state = State.PASS_THROUGH;
                    break;
                }
                if (bl && !((ByteBufHolder)((Object)httpResponse)).content().isReadable()) {
                    list.add(ReferenceCountUtil.retain(httpResponse));
                    break;
                }
                Result result = this.beginEncode(httpResponse, this.acceptEncoding.toString());
                if (result == null) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        break;
                    }
                    list.add(httpResponse);
                    this.state = State.PASS_THROUGH;
                    break;
                }
                this.encoder = result.contentEncoder();
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)result.targetContentEncoding());
                httpResponse.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
                httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                if (bl) {
                    DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(httpResponse.protocolVersion(), httpResponse.status());
                    defaultHttpResponse.headers().set(httpResponse.headers());
                    list.add(defaultHttpResponse);
                } else {
                    list.add(httpResponse);
                    this.state = State.AWAIT_CONTENT;
                    if (!(httpObject instanceof HttpContent)) break;
                }
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(httpObject);
                if (!this.encodeContent((HttpContent)httpObject, list)) break;
                this.state = State.AWAIT_HEADERS;
                break;
            }
            case PASS_THROUGH: {
                HttpContentEncoder.ensureContent(httpObject);
                list.add(ReferenceCountUtil.retain(httpObject));
                if (!(httpObject instanceof LastHttpContent)) break;
                this.state = State.AWAIT_HEADERS;
            }
        }
    }

    private static boolean isPassthru(HttpVersion httpVersion, int n, CharSequence charSequence) {
        return n < 200 || n == 204 || n == 304 || charSequence == ZERO_LENGTH_HEAD || charSequence == ZERO_LENGTH_CONNECT && n == 200 || httpVersion == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject httpObject) {
        if (!(httpObject instanceof HttpResponse)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ')');
        }
    }

    private static void ensureContent(HttpObject httpObject) {
        if (!(httpObject instanceof HttpContent)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ')');
        }
    }

    private boolean encodeContent(HttpContent httpContent, List<Object> list) {
        ByteBuf byteBuf = httpContent.content();
        this.encode(byteBuf, list);
        if (httpContent instanceof LastHttpContent) {
            this.finishEncode(list);
            LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
            HttpHeaders httpHeaders = lastHttpContent.trailingHeaders();
            if (httpHeaders.isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                list.add(new ComposedLastHttpContent(httpHeaders));
            }
            return true;
        }
        return false;
    }

    protected abstract Result beginEncode(HttpResponse var1, String var2) throws Exception;

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    private void cleanup() {
        if (this.encoder != null) {
            if (this.encoder.finish()) {
                ByteBuf byteBuf;
                while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
                    byteBuf.release();
                }
            }
            this.encoder = null;
        }
    }

    private void encode(ByteBuf byteBuf, List<Object> list) {
        this.encoder.writeOutbound(byteBuf.retain());
        this.fetchEncoderOutput(list);
    }

    private void finishEncode(List<Object> list) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(list);
        }
        this.encoder = null;
    }

    private void fetchEncoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final EmbeddedChannel contentEncoder;

        public Result(String string, EmbeddedChannel embeddedChannel) {
            if (string == null) {
                throw new NullPointerException("targetContentEncoding");
            }
            if (embeddedChannel == null) {
                throw new NullPointerException("contentEncoder");
            }
            this.targetContentEncoding = string;
            this.contentEncoder = embeddedChannel;
        }

        public String targetContentEncoding() {
            return this.targetContentEncoding;
        }

        public EmbeddedChannel contentEncoder() {
            return this.contentEncoder;
        }
    }

    private static enum State {
        PASS_THROUGH,
        AWAIT_HEADERS,
        AWAIT_CONTENT;

    }
}

