/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;
import java.text.ParseException;

public class CharSequenceValueConverter
implements ValueConverter<CharSequence> {
    public static final CharSequenceValueConverter INSTANCE = new CharSequenceValueConverter();

    @Override
    public CharSequence convertObject(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return object.toString();
    }

    @Override
    public CharSequence convertInt(int n) {
        return String.valueOf(n);
    }

    @Override
    public CharSequence convertLong(long l) {
        return String.valueOf(l);
    }

    @Override
    public CharSequence convertDouble(double d) {
        return String.valueOf(d);
    }

    @Override
    public CharSequence convertChar(char c) {
        return String.valueOf(c);
    }

    @Override
    public CharSequence convertBoolean(boolean bl) {
        return String.valueOf(bl);
    }

    @Override
    public CharSequence convertFloat(float f) {
        return String.valueOf(f);
    }

    @Override
    public boolean convertToBoolean(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseBoolean();
        }
        return Boolean.parseBoolean(charSequence.toString());
    }

    @Override
    public CharSequence convertByte(byte by) {
        return String.valueOf(by);
    }

    @Override
    public byte convertToByte(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).byteAt(0);
        }
        return Byte.valueOf(charSequence.toString());
    }

    @Override
    public char convertToChar(CharSequence charSequence) {
        return charSequence.charAt(0);
    }

    @Override
    public CharSequence convertShort(short s) {
        return String.valueOf(s);
    }

    @Override
    public short convertToShort(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseShort();
        }
        return Short.valueOf(charSequence.toString());
    }

    @Override
    public int convertToInt(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseInt();
        }
        return Integer.parseInt(charSequence.toString());
    }

    @Override
    public long convertToLong(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseLong();
        }
        return Long.parseLong(charSequence.toString());
    }

    @Override
    public CharSequence convertTimeMillis(long l) {
        return String.valueOf(l);
    }

    @Override
    public long convertToTimeMillis(CharSequence charSequence) {
        try {
            return DefaultHeaders.HeaderDateFormat.get().parse(charSequence.toString());
        }
        catch (ParseException parseException) {
            PlatformDependent.throwException(parseException);
            return 0L;
        }
    }

    @Override
    public float convertToFloat(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseFloat();
        }
        return Float.valueOf(charSequence.toString()).floatValue();
    }

    @Override
    public double convertToDouble(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return ((AsciiString)charSequence).parseDouble();
        }
        return Double.valueOf(charSequence.toString());
    }
}

