/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openSocketChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(NioSocketChannel.newSocket(selectorProvider));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        this.config = new NioSocketChannelConfig(this, socketChannel.socket());
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.javaChannel().socket().isOutputShutdown() || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.javaChannel().socket().isInputShutdown() || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        Socket socket = this.javaChannel().socket();
        return socket.isInputShutdown() && socket.isOutputShutdown() || !this.isActive();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(final ChannelPromise channelPromise) {
        Executor executor = ((NioSocketChannelUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    NioSocketChannel.this.shutdownOutput0(channelPromise);
                }
            });
        } else {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.shutdownOutput0(channelPromise);
            } else {
                nioEventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        NioSocketChannel.this.shutdownOutput0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(final ChannelPromise channelPromise) {
        Executor executor = ((NioSocketChannelUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    NioSocketChannel.this.shutdownInput0(channelPromise);
                }
            });
        } else {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.shutdownInput0(channelPromise);
            } else {
                nioEventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        NioSocketChannel.this.shutdownInput0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(final ChannelPromise channelPromise) {
        Executor executor = ((NioSocketChannelUnsafe)this.unsafe()).prepareToClose();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    NioSocketChannel.this.shutdown0(channelPromise);
                }
            });
        } else {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.shutdown0(channelPromise);
            } else {
                nioEventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        NioSocketChannel.this.shutdown0(channelPromise);
                    }
                });
            }
        }
        return channelPromise;
    }

    private void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.javaChannel().socket().shutdownOutput();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.javaChannel().socket().shutdownInput();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    private void shutdown0(ChannelPromise channelPromise) {
        Socket socket = this.javaChannel().socket();
        Throwable throwable = null;
        try {
            socket.shutdownOutput();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        try {
            socket.shutdownInput();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                channelPromise.setFailure(throwable3);
            } else {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable3);
                channelPromise.setFailure(throwable);
            }
            return;
        }
        if (throwable == null) {
            channelPromise.setSuccess();
        } else {
            channelPromise.setFailure(throwable);
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.javaChannel().socket().bind(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) throws Exception {
        if (socketAddress2 != null) {
            this.javaChannel().socket().bind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = this.javaChannel().connect(socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() throws Exception {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes(this.javaChannel(), handle.attemptedBytesRead());
    }

    @Override
    protected int doWriteBytes(ByteBuf byteBuf) throws Exception {
        int n = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n);
    }

    @Override
    protected long doWriteFileRegion(FileRegion fileRegion) throws Exception {
        long l = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l);
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        block10: {
            boolean bl;
            boolean bl2;
            do {
                int n;
                if ((n = channelOutboundBuffer.size()) == 0) {
                    this.clearOpWrite();
                    break block10;
                }
                long l = 0L;
                bl2 = false;
                bl = false;
                ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers();
                int n2 = channelOutboundBuffer.nioBufferCount();
                long l2 = channelOutboundBuffer.nioBufferSize();
                java.nio.channels.SocketChannel socketChannel = this.javaChannel();
                block0 : switch (n2) {
                    case 0: {
                        super.doWrite(channelOutboundBuffer);
                        return;
                    }
                    case 1: {
                        int n3;
                        ByteBuffer byteBuffer = byteBufferArray[0];
                        for (n3 = this.config().getWriteSpinCount() - 1; n3 >= 0; --n3) {
                            int n4 = socketChannel.write(byteBuffer);
                            if (n4 == 0) {
                                bl = true;
                                break block0;
                            }
                            l += (long)n4;
                            if ((l2 -= (long)n4) != 0L) continue;
                            bl2 = true;
                            break block0;
                        }
                        break;
                    }
                    default: {
                        int n3;
                        for (n3 = this.config().getWriteSpinCount() - 1; n3 >= 0; --n3) {
                            long l3 = socketChannel.write(byteBufferArray, 0, n2);
                            if (l3 == 0L) {
                                bl = true;
                                break block0;
                            }
                            l += l3;
                            if ((l2 -= l3) != 0L) continue;
                            bl2 = true;
                            break block0;
                        }
                    }
                }
                channelOutboundBuffer.removeBytes(l);
            } while (bl2);
            this.incompleteWrite(bl);
        }
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannelUnsafe();
    }

    private final class NioSocketChannelConfig
    extends DefaultSocketChannelConfig {
        private NioSocketChannelConfig(NioSocketChannel nioSocketChannel2, Socket socket) {
            super(nioSocketChannel2, socket);
        }

        @Override
        protected void autoReadCleared() {
            NioSocketChannel.this.clearReadPending();
        }
    }

    private final class NioSocketChannelUnsafe
    extends AbstractNioByteChannel.NioByteUnsafe {
        private NioSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (NioSocketChannel.this.javaChannel().isOpen() && NioSocketChannel.this.config().getSoLinger() > 0) {
                    NioSocketChannel.this.doDeregister();
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

