/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import java.util.Deque;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance("channelPool");
    private static final IllegalStateException FULL_EXCEPTION = ThrowableUtil.unknownStackTrace(new IllegalStateException("ChannelPool full"), SimpleChannelPool.class, "releaseAndOffer(...)");
    private static final IllegalStateException UNHEALTHY_NON_OFFERED_TO_POOL = ThrowableUtil.unknownStackTrace(new IllegalStateException("Channel is unhealthy not offering it back to pool"), SimpleChannelPool.class, "releaseAndOffer(...)");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, final ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl) {
        this.handler = ObjectUtil.checkNotNull(channelPoolHandler, "handler");
        this.healthCheck = ObjectUtil.checkNotNull(channelHealthChecker, "healthCheck");
        this.releaseHealthCheck = bl;
        this.bootstrap = ObjectUtil.checkNotNull(bootstrap, "bootstrap").clone();
        this.bootstrap.handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) throws Exception {
                assert (channel.eventLoop().inEventLoop());
                channelPoolHandler.channelCreated(channel);
            }
        });
    }

    @Override
    public final Future<Channel> acquire() {
        return this.acquire(this.bootstrap.config().group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        return this.acquireHealthyFromPoolOrNew(promise);
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(final Promise<Channel> promise) {
        try {
            final Channel channel = this.pollChannel();
            if (channel == null) {
                Bootstrap bootstrap = this.bootstrap.clone();
                bootstrap.attr(POOL_KEY, this);
                ChannelFuture channelFuture = this.connectChannel(bootstrap);
                if (channelFuture.isDone()) {
                    this.notifyConnect(channelFuture, promise);
                } else {
                    channelFuture.addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            SimpleChannelPool.this.notifyConnect(channelFuture, promise);
                        }
                    });
                }
                return promise;
            }
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doHealthCheck(channel, promise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleChannelPool.this.doHealthCheck(channel, promise);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void notifyConnect(ChannelFuture channelFuture, Promise<Channel> promise) {
        if (channelFuture.isSuccess()) {
            Channel channel = channelFuture.channel();
            if (!promise.trySuccess(channel)) {
                this.release(channel);
            }
        } else {
            promise.tryFailure(channelFuture.cause());
        }
    }

    private void doHealthCheck(final Channel channel, final Promise<Channel> promise) {
        assert (channel.eventLoop().inEventLoop());
        Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.notifyHealthCheck(future, channel, promise);
        } else {
            future.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                @Override
                public void operationComplete(Future<Boolean> future) throws Exception {
                    SimpleChannelPool.this.notifyHealthCheck(future, channel, promise);
                }
            });
        }
    }

    private void notifyHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        assert (channel.eventLoop().inEventLoop());
        if (future.isSuccess()) {
            if (future.getNow().booleanValue()) {
                try {
                    channel.attr(POOL_KEY).set(this);
                    this.handler.channelAcquired(channel);
                    promise.setSuccess(channel);
                }
                catch (Throwable throwable) {
                    SimpleChannelPool.closeAndFail(channel, throwable, promise);
                }
            } else {
                SimpleChannelPool.closeChannel(channel);
                this.acquireHealthyFromPoolOrNew(promise);
            }
        } else {
            SimpleChannelPool.closeChannel(channel);
            this.acquireHealthyFromPoolOrNew(promise);
        }
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        return bootstrap.connect();
    }

    @Override
    public final Future<Void> release(Channel channel) {
        return this.release(channel, channel.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(final Channel channel, final Promise<Void> promise) {
        ObjectUtil.checkNotNull(channel, "channel");
        ObjectUtil.checkNotNull(promise, "promise");
        try {
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doReleaseChannel(channel, promise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleChannelPool.this.doReleaseChannel(channel, promise);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            SimpleChannelPool.closeAndFail(channel, throwable, promise);
        }
        return promise;
    }

    private void doReleaseChannel(Channel channel, Promise<Void> promise) {
        assert (channel.eventLoop().inEventLoop());
        if (channel.attr(POOL_KEY).getAndSet(null) != this) {
            SimpleChannelPool.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
        } else {
            try {
                if (this.releaseHealthCheck) {
                    this.doHealthCheckOnRelease(channel, promise);
                } else {
                    this.releaseAndOffer(channel, promise);
                }
            }
            catch (Throwable throwable) {
                SimpleChannelPool.closeAndFail(channel, throwable, promise);
            }
        }
    }

    private void doHealthCheckOnRelease(final Channel channel, final Promise<Void> promise) throws Exception {
        final Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise, future);
        } else {
            future.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

                @Override
                public void operationComplete(Future<Boolean> future2) throws Exception {
                    SimpleChannelPool.this.releaseAndOfferIfHealthy(channel, promise, future);
                }
            });
        }
    }

    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) throws Exception {
        if (future.getNow().booleanValue()) {
            this.releaseAndOffer(channel, promise);
        } else {
            this.handler.channelReleased(channel);
            SimpleChannelPool.closeAndFail(channel, UNHEALTHY_NON_OFFERED_TO_POOL, promise);
        }
    }

    private void releaseAndOffer(Channel channel, Promise<Void> promise) throws Exception {
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise.setSuccess(null);
        } else {
            SimpleChannelPool.closeAndFail(channel, FULL_EXCEPTION, promise);
        }
    }

    private static void closeChannel(Channel channel) {
        channel.attr(POOL_KEY).getAndSet(null);
        channel.close();
    }

    private static void closeAndFail(Channel channel, Throwable throwable, Promise<?> promise) {
        SimpleChannelPool.closeChannel(channel);
        promise.tryFailure(throwable);
    }

    protected Channel pollChannel() {
        return this.deque.pollLast();
    }

    protected boolean offerChannel(Channel channel) {
        return this.deque.offer(channel);
    }

    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            channel.close();
        }
    }
}

