/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.epoll.NativeStaticallyReferencedJniMethods;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;

public final class Native {
    public static final int EPOLLIN;
    public static final int EPOLLOUT;
    public static final int EPOLLRDHUP;
    public static final int EPOLLET;
    public static final int EPOLLERR;
    public static final int IOV_MAX;
    public static final int UIO_MAX_IOV;
    public static final boolean IS_SUPPORTING_SENDMMSG;
    public static final boolean IS_SUPPORTING_TCP_FASTOPEN;
    public static final long SSIZE_MAX;
    public static final int TCP_MD5SIG_MAXKEYLEN;
    public static final String KERNEL_VERSION;
    private static final Errors.NativeIoException SENDFILE_CONNECTION_RESET_EXCEPTION;
    private static final Errors.NativeIoException SENDMMSG_CONNECTION_RESET_EXCEPTION;
    private static final Errors.NativeIoException SPLICE_CONNECTION_RESET_EXCEPTION;
    private static final ClosedChannelException SENDFILE_CLOSED_CHANNEL_EXCEPTION;
    private static final ClosedChannelException SENDMMSG_CLOSED_CHANNEL_EXCEPTION;
    private static final ClosedChannelException SPLICE_CLOSED_CHANNEL_EXCEPTION;

    public static FileDescriptor newEventFd() {
        return new FileDescriptor(Native.eventFd());
    }

    private static native int eventFd();

    public static native void eventFdWrite(int var0, long var1);

    public static native void eventFdRead(int var0);

    public static FileDescriptor newEpollCreate() {
        return new FileDescriptor(Native.epollCreate());
    }

    private static native int epollCreate();

    public static int epollWait(int n, EpollEventArray epollEventArray, int n2) throws IOException {
        int n3 = Native.epollWait0(n, epollEventArray.memoryAddress(), epollEventArray.length(), n2);
        if (n3 < 0) {
            throw Errors.newIOException("epoll_wait", n3);
        }
        return n3;
    }

    private static native int epollWait0(int var0, long var1, int var3, int var4);

    public static void epollCtlAdd(int n, int n2, int n3) throws IOException {
        int n4 = Native.epollCtlAdd0(n, n2, n3);
        if (n4 < 0) {
            throw Errors.newIOException("epoll_ctl", n4);
        }
    }

    private static native int epollCtlAdd0(int var0, int var1, int var2);

    public static void epollCtlMod(int n, int n2, int n3) throws IOException {
        int n4 = Native.epollCtlMod0(n, n2, n3);
        if (n4 < 0) {
            throw Errors.newIOException("epoll_ctl", n4);
        }
    }

    private static native int epollCtlMod0(int var0, int var1, int var2);

    public static void epollCtlDel(int n, int n2) throws IOException {
        int n3 = Native.epollCtlDel0(n, n2);
        if (n3 < 0) {
            throw Errors.newIOException("epoll_ctl", n3);
        }
    }

    private static native int epollCtlDel0(int var0, int var1);

    public static int splice(int n, long l, int n2, long l2, long l3) throws IOException {
        int n3 = Native.splice0(n, l, n2, l2, l3);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("splice", n3, SPLICE_CONNECTION_RESET_EXCEPTION, SPLICE_CLOSED_CHANNEL_EXCEPTION);
    }

    private static native int splice0(int var0, long var1, int var3, long var4, long var6);

    public static long sendfile(int n, DefaultFileRegion defaultFileRegion, long l, long l2, long l3) throws IOException {
        defaultFileRegion.open();
        long l4 = Native.sendfile0(n, defaultFileRegion, l, l2, l3);
        if (l4 >= 0L) {
            return l4;
        }
        return Errors.ioResult("sendfile", (int)l4, SENDFILE_CONNECTION_RESET_EXCEPTION, SENDFILE_CLOSED_CHANNEL_EXCEPTION);
    }

    private static native long sendfile0(int var0, DefaultFileRegion var1, long var2, long var4, long var6) throws IOException;

    public static int sendmmsg(int n, NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray, int n2, int n3) throws IOException {
        int n4 = Native.sendmmsg0(n, nativeDatagramPacketArray, n2, n3);
        if (n4 >= 0) {
            return n4;
        }
        return Errors.ioResult("sendmmsg", n4, SENDMMSG_CONNECTION_RESET_EXCEPTION, SENDMMSG_CLOSED_CHANNEL_EXCEPTION);
    }

    private static native int sendmmsg0(int var0, NativeDatagramPacketArray.NativeDatagramPacket[] var1, int var2, int var3);

    public static int recvFd(int n) throws IOException {
        int n2 = Native.recvFd0(n);
        if (n2 > 0) {
            return n2;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == Errors.ERRNO_EAGAIN_NEGATIVE || n2 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", n2);
    }

    private static native int recvFd0(int var0);

    public static int sendFd(int n, int n2) throws IOException {
        int n3 = Native.sendFd0(n, n2);
        if (n3 >= 0) {
            return n3;
        }
        if (n3 == Errors.ERRNO_EAGAIN_NEGATIVE || n3 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", n3);
    }

    private static native int sendFd0(int var0, int var1);

    public static native int isReuseAddress(int var0) throws IOException;

    public static native int isReusePort(int var0) throws IOException;

    public static native int getTcpNotSentLowAt(int var0) throws IOException;

    public static native int getTrafficClass(int var0) throws IOException;

    public static native int isBroadcast(int var0) throws IOException;

    public static native int getTcpKeepIdle(int var0) throws IOException;

    public static native int getTcpKeepIntvl(int var0) throws IOException;

    public static native int getTcpKeepCnt(int var0) throws IOException;

    public static native int getTcpUserTimeout(int var0) throws IOException;

    public static native int isIpFreeBind(int var0) throws IOException;

    public static native void setReuseAddress(int var0, int var1) throws IOException;

    public static native void setReusePort(int var0, int var1) throws IOException;

    public static native void setTcpFastopen(int var0, int var1) throws IOException;

    public static native void setTcpNotSentLowAt(int var0, int var1) throws IOException;

    public static native void setTrafficClass(int var0, int var1) throws IOException;

    public static native void setBroadcast(int var0, int var1) throws IOException;

    public static native void setTcpKeepIdle(int var0, int var1) throws IOException;

    public static native void setTcpKeepIntvl(int var0, int var1) throws IOException;

    public static native void setTcpKeepCnt(int var0, int var1) throws IOException;

    public static native void setTcpUserTimeout(int var0, int var1) throws IOException;

    public static native void setIpFreeBind(int var0, int var1) throws IOException;

    public static void tcpInfo(int n, EpollTcpInfo epollTcpInfo) throws IOException {
        Native.tcpInfo0(n, epollTcpInfo.info);
    }

    private static native void tcpInfo0(int var0, int[] var1) throws IOException;

    public static void setTcpMd5Sig(int n, InetAddress inetAddress, byte[] byArray) throws IOException {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetAddress);
        Native.setTcpMd5Sig0(n, nativeInetAddress.address(), nativeInetAddress.scopeId(), byArray);
    }

    private static native void setTcpMd5Sig0(int var0, byte[] var1, int var2, byte[] var3) throws IOException;

    public static native int sizeofEpollEvent();

    public static native int offsetofEpollData();

    private Native() {
    }

    private static void loadNativeLibrary() {
        String string = SystemPropertyUtil.get("os.name").toLowerCase(Locale.UK).trim();
        if (!string.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        NativeLibraryLoader.load(SystemPropertyUtil.get("io.netty.packagePrefix", "").replace('.', '-') + "netty-transport-native-epoll", PlatformDependent.getClassLoader(Native.class));
    }

    static {
        try {
            Native.offsetofEpollData();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Native.loadNativeLibrary();
        }
        EPOLLIN = NativeStaticallyReferencedJniMethods.epollin();
        EPOLLOUT = NativeStaticallyReferencedJniMethods.epollout();
        EPOLLRDHUP = NativeStaticallyReferencedJniMethods.epollrdhup();
        EPOLLET = NativeStaticallyReferencedJniMethods.epollet();
        EPOLLERR = NativeStaticallyReferencedJniMethods.epollerr();
        IOV_MAX = NativeStaticallyReferencedJniMethods.iovMax();
        UIO_MAX_IOV = NativeStaticallyReferencedJniMethods.uioMaxIov();
        IS_SUPPORTING_SENDMMSG = NativeStaticallyReferencedJniMethods.isSupportingSendmmsg();
        IS_SUPPORTING_TCP_FASTOPEN = NativeStaticallyReferencedJniMethods.isSupportingTcpFastopen();
        SSIZE_MAX = NativeStaticallyReferencedJniMethods.ssizeMax();
        TCP_MD5SIG_MAXKEYLEN = NativeStaticallyReferencedJniMethods.tcpMd5SigMaxKeyLen();
        KERNEL_VERSION = NativeStaticallyReferencedJniMethods.kernelVersion();
        SENDFILE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Native.class, "sendfile(...)");
        SENDMMSG_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Native.class, "sendmmsg(...)");
        SPLICE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Native.class, "splice(...)");
        SENDFILE_CONNECTION_RESET_EXCEPTION = Errors.newConnectionResetException("syscall:sendfile(...)", Errors.ERRNO_EPIPE_NEGATIVE);
        SENDMMSG_CONNECTION_RESET_EXCEPTION = Errors.newConnectionResetException("syscall:sendmmsg(...)", Errors.ERRNO_EPIPE_NEGATIVE);
        SPLICE_CONNECTION_RESET_EXCEPTION = Errors.newConnectionResetException("syscall:splice(...)", Errors.ERRNO_EPIPE_NEGATIVE);
    }
}

