/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;

public final class EpollSocketChannelConfig
extends EpollChannelConfig
implements SocketChannelConfig {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;
    private final EpollSocketChannel channel;
    private volatile boolean allowHalfClosure;

    EpollSocketChannelConfig(EpollSocketChannel epollSocketChannel) {
        super(epollSocketChannel);
        this.channel = epollSocketChannel;
        if (PlatformDependent.canEnableTcpNoDelayByDefault()) {
            this.setTcpNoDelay(true);
        }
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.TCP_NODELAY, ChannelOption.SO_KEEPALIVE, ChannelOption.SO_REUSEADDR, ChannelOption.SO_LINGER, ChannelOption.IP_TOS, ChannelOption.ALLOW_HALF_CLOSURE, EpollChannelOption.TCP_CORK, EpollChannelOption.TCP_NOTSENT_LOWAT, EpollChannelOption.TCP_KEEPCNT, EpollChannelOption.TCP_KEEPIDLE, EpollChannelOption.TCP_KEEPINTVL, EpollChannelOption.TCP_MD5SIG, EpollChannelOption.TCP_QUICKACK);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == ChannelOption.TCP_NODELAY) {
            return (T)Boolean.valueOf(this.isTcpNoDelay());
        }
        if (channelOption == ChannelOption.SO_KEEPALIVE) {
            return (T)Boolean.valueOf(this.isKeepAlive());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        if (channelOption == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (channelOption == ChannelOption.ALLOW_HALF_CLOSURE) {
            return (T)Boolean.valueOf(this.isAllowHalfClosure());
        }
        if (channelOption == EpollChannelOption.TCP_CORK) {
            return (T)Boolean.valueOf(this.isTcpCork());
        }
        if (channelOption == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            return (T)Long.valueOf(this.getTcpNotSentLowAt());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPIDLE) {
            return (T)Integer.valueOf(this.getTcpKeepIdle());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPINTVL) {
            return (T)Integer.valueOf(this.getTcpKeepIntvl());
        }
        if (channelOption == EpollChannelOption.TCP_KEEPCNT) {
            return (T)Integer.valueOf(this.getTcpKeepCnt());
        }
        if (channelOption == EpollChannelOption.TCP_USER_TIMEOUT) {
            return (T)Integer.valueOf(this.getTcpUserTimeout());
        }
        if (channelOption == EpollChannelOption.TCP_QUICKACK) {
            return (T)Boolean.valueOf(this.isTcpQuickAck());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t) {
        this.validate(channelOption, t);
        if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t);
        } else if (channelOption == ChannelOption.TCP_NODELAY) {
            this.setTcpNoDelay((Boolean)t);
        } else if (channelOption == ChannelOption.SO_KEEPALIVE) {
            this.setKeepAlive((Boolean)t);
        } else if (channelOption == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t);
        } else if (channelOption == ChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)t);
        } else if (channelOption == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)t);
        } else if (channelOption == ChannelOption.ALLOW_HALF_CLOSURE) {
            this.setAllowHalfClosure((Boolean)t);
        } else if (channelOption == EpollChannelOption.TCP_CORK) {
            this.setTcpCork((Boolean)t);
        } else if (channelOption == EpollChannelOption.TCP_NOTSENT_LOWAT) {
            this.setTcpNotSentLowAt((Long)t);
        } else if (channelOption == EpollChannelOption.TCP_KEEPIDLE) {
            this.setTcpKeepIdle((Integer)t);
        } else if (channelOption == EpollChannelOption.TCP_KEEPCNT) {
            this.setTcpKeepCntl((Integer)t);
        } else if (channelOption == EpollChannelOption.TCP_KEEPINTVL) {
            this.setTcpKeepIntvl((Integer)t);
        } else if (channelOption == EpollChannelOption.TCP_USER_TIMEOUT) {
            this.setTcpUserTimeout((Integer)t);
        } else if (channelOption == EpollChannelOption.TCP_MD5SIG) {
            Map map = (Map)t;
            this.setTcpMd5Sig(map);
        } else if (channelOption == EpollChannelOption.TCP_QUICKACK) {
            this.setTcpQuickAck((Boolean)t);
        } else {
            return super.setOption(channelOption, t);
        }
        return true;
    }

    @Override
    public int getReceiveBufferSize() {
        try {
            return this.channel.fd().getReceiveBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getSendBufferSize() {
        try {
            return this.channel.fd().getSendBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getSoLinger() {
        try {
            return this.channel.fd().getSoLinger();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getTrafficClass() {
        try {
            return Native.getTrafficClass(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isKeepAlive() {
        try {
            return this.channel.fd().isKeepAlive();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isReuseAddress() {
        try {
            return Native.isReuseAddress(this.channel.fd().intValue()) == 1;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isTcpNoDelay() {
        try {
            return this.channel.fd().isTcpNoDelay();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isTcpCork() {
        try {
            return this.channel.fd().isTcpCork();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public long getTcpNotSentLowAt() {
        try {
            return (long)Native.getTcpNotSentLowAt(this.channel.fd().intValue()) & 0xFFFFFFFFL;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepIdle() {
        try {
            return Native.getTcpKeepIdle(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepIntvl() {
        try {
            return Native.getTcpKeepIntvl(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpKeepCnt() {
        try {
            return Native.getTcpKeepCnt(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public int getTcpUserTimeout() {
        try {
            return Native.getTcpUserTimeout(this.channel.fd().intValue());
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setKeepAlive(boolean bl) {
        try {
            this.channel.fd().setKeepAlive(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setPerformancePreferences(int n, int n2, int n3) {
        return this;
    }

    @Override
    public EpollSocketChannelConfig setReceiveBufferSize(int n) {
        try {
            this.channel.fd().setReceiveBufferSize(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setReuseAddress(boolean bl) {
        try {
            Native.setReuseAddress(this.channel.fd().intValue(), bl ? 1 : 0);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setSendBufferSize(int n) {
        try {
            this.channel.fd().setSendBufferSize(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setSoLinger(int n) {
        try {
            this.channel.fd().setSoLinger(n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setTcpNoDelay(boolean bl) {
        try {
            this.channel.fd().setTcpNoDelay(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpCork(boolean bl) {
        try {
            this.channel.fd().setTcpCork(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpNotSentLowAt(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        try {
            Native.setTcpNotSentLowAt(this.channel.fd().intValue(), (int)l);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public EpollSocketChannelConfig setTrafficClass(int n) {
        try {
            Native.setTrafficClass(this.channel.fd().intValue(), n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpKeepIdle(int n) {
        try {
            Native.setTcpKeepIdle(this.channel.fd().intValue(), n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpKeepIntvl(int n) {
        try {
            Native.setTcpKeepIntvl(this.channel.fd().intValue(), n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpKeepCntl(int n) {
        try {
            Native.setTcpKeepCnt(this.channel.fd().intValue(), n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpUserTimeout(int n) {
        try {
            Native.setTcpUserTimeout(this.channel.fd().intValue(), n);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpMd5Sig(Map<InetAddress, byte[]> map) {
        try {
            this.channel.setTcpMd5Sig(map);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public EpollSocketChannelConfig setTcpQuickAck(boolean bl) {
        try {
            this.channel.fd().setTcpQuickAck(bl);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public boolean isTcpQuickAck() {
        try {
            return this.channel.fd().isTcpQuickAck();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isAllowHalfClosure() {
        return this.allowHalfClosure;
    }

    @Override
    public EpollSocketChannelConfig setAllowHalfClosure(boolean bl) {
        this.allowHalfClosure = bl;
        return this;
    }

    @Override
    public EpollSocketChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setAutoClose(boolean bl) {
        super.setAutoClose(bl);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Override
    @Deprecated
    public EpollSocketChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    public EpollSocketChannelConfig setEpollMode(EpollMode epollMode) {
        super.setEpollMode(epollMode);
        return this;
    }
}

