/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.Channel;
import io.netty.channel.epoll.AbstractEpollServerChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollServerChannelConfig;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;

public final class EpollServerDomainSocketChannel
extends AbstractEpollServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollServerDomainSocketChannel.class);
    private final EpollServerChannelConfig config = new EpollServerChannelConfig(this);
    private volatile DomainSocketAddress local;

    public EpollServerDomainSocketChannel() {
        super(Socket.newSocketDomain(), false);
    }

    public EpollServerDomainSocketChannel(FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    public EpollServerDomainSocketChannel(Socket socket) {
        super(socket);
    }

    public EpollServerDomainSocketChannel(Socket socket, boolean bl) {
        super(socket, bl);
    }

    @Override
    protected Channel newChildChannel(int n, byte[] byArray, int n2, int n3) throws Exception {
        return new EpollDomainSocketChannel((Channel)this, new Socket(n));
    }

    @Override
    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.fd().bind(socketAddress);
        this.fd().listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws Exception {
        try {
            super.doClose();
        }
        finally {
            File file;
            boolean bl;
            DomainSocketAddress domainSocketAddress = this.local;
            if (domainSocketAddress != null && !(bl = (file = new File(domainSocketAddress.path())).delete()) && logger.isDebugEnabled()) {
                logger.debug("Failed to delete a domain socket file: {}", (Object)domainSocketAddress.path());
            }
        }
    }

    @Override
    public EpollServerChannelConfig config() {
        return this.config;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }
}

