/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.IovArray;
import io.netty.channel.epoll.Native;
import io.netty.channel.epoll.NativeDatagramPacketArray;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.List;

public final class EpollDatagramChannel
extends AbstractEpollChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(InetSocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private volatile InetSocketAddress local;
    private volatile InetSocketAddress remote;
    private volatile boolean connected;
    private final EpollDatagramChannelConfig config;

    public EpollDatagramChannel() {
        super(Socket.newSocketDgram(), Native.EPOLLIN);
        this.config = new EpollDatagramChannelConfig(this);
    }

    @Deprecated
    public EpollDatagramChannel(FileDescriptor fileDescriptor) {
        this(new Socket(fileDescriptor.intValue()));
    }

    public EpollDatagramChannel(Socket socket) {
        super(null, socket, Native.EPOLLIN, true);
        this.local = socket.localAddress();
        this.config = new EpollDatagramChannelConfig(this);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public boolean isActive() {
        return this.fd().isOpen() && (this.config.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || this.active);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.joinGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (inetAddress2 == null) {
            throw new NullPointerException("sourceToBlock");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        channelPromise.setFailure(new UnsupportedOperationException("Multicast not supported"));
        return channelPromise;
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    protected AbstractEpollChannel.AbstractEpollUnsafe newUnsafe() {
        return new EpollDatagramChannelUnsafe();
    }

    @Override
    protected InetSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected InetSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        EpollDatagramChannel.checkResolvable(inetSocketAddress);
        this.fd().bind(inetSocketAddress);
        this.local = this.fd().localAddress();
        this.active = true;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        block2: while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                this.clearFlag(Native.EPOLLOUT);
                break;
            }
            try {
                NativeDatagramPacketArray nativeDatagramPacketArray;
                int n;
                if (Native.IS_SUPPORTING_SENDMMSG && channelOutboundBuffer.size() > 1 && (n = (nativeDatagramPacketArray = NativeDatagramPacketArray.getInstance(channelOutboundBuffer)).count()) >= 1) {
                    int n2 = 0;
                    NativeDatagramPacketArray.NativeDatagramPacket[] nativeDatagramPacketArray2 = nativeDatagramPacketArray.packets();
                    while (true) {
                        if (n <= 0) continue block2;
                        int n3 = Native.sendmmsg(this.fd().intValue(), nativeDatagramPacketArray2, n2, n);
                        if (n3 == 0) {
                            this.setFlag(Native.EPOLLOUT);
                            return;
                        }
                        for (int i = 0; i < n3; ++i) {
                            channelOutboundBuffer.remove();
                        }
                        n -= n3;
                        n2 += n3;
                    }
                }
                boolean bl = false;
                for (n = this.config().getWriteSpinCount() - 1; n >= 0; --n) {
                    if (!this.doWriteMessage(object)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                this.setFlag(Native.EPOLLOUT);
            }
            catch (IOException iOException) {
                channelOutboundBuffer.remove(iOException);
                continue;
            }
            break;
        }
    }

    private boolean doWriteMessage(Object object) throws Exception {
        int n;
        InetSocketAddress inetSocketAddress;
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            byteBuf = (ByteBuf)addressedEnvelope.content();
            inetSocketAddress = (InetSocketAddress)addressedEnvelope.recipient();
        } else {
            byteBuf = (ByteBuf)object;
            inetSocketAddress = null;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        if (inetSocketAddress == null && (inetSocketAddress = this.remote) == null) {
            throw new NotYetConnectedException();
        }
        if (byteBuf.hasMemoryAddress()) {
            long l = byteBuf.memoryAddress();
            n = this.fd().sendToAddress(l, byteBuf.readerIndex(), byteBuf.writerIndex(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else if (byteBuf instanceof CompositeByteBuf) {
            IovArray iovArray = ((EpollEventLoop)this.eventLoop()).cleanArray();
            iovArray.add(byteBuf);
            int n3 = iovArray.count();
            assert (n3 != 0);
            n = this.fd().sendToAddresses(iovArray.memoryAddress(0), n3, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes());
            n = this.fd().sendTo(byteBuffer, byteBuffer.position(), byteBuffer.limit(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        return n > 0;
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DatagramPacket) {
            CompositeByteBuf compositeByteBuf;
            DatagramPacket datagramPacket = (DatagramPacket)object;
            ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
            if (byteBuf.hasMemoryAddress()) {
                return object;
            }
            if (byteBuf.isDirect() && byteBuf instanceof CompositeByteBuf && (compositeByteBuf = (CompositeByteBuf)byteBuf).isDirect() && compositeByteBuf.nioBufferCount() <= Native.IOV_MAX) {
                return object;
            }
            return new DatagramPacket(this.newDirectBuffer(datagramPacket, byteBuf), (InetSocketAddress)datagramPacket.recipient());
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!(byteBuf.hasMemoryAddress() || !PlatformDependent.hasUnsafe() && byteBuf.isDirect())) {
                if (byteBuf instanceof CompositeByteBuf) {
                    CompositeByteBuf compositeByteBuf = (CompositeByteBuf)byteBuf;
                    if (!compositeByteBuf.isDirect() || compositeByteBuf.nioBufferCount() > Native.IOV_MAX) {
                        byteBuf = this.newDirectBuffer(byteBuf);
                        assert (byteBuf.hasMemoryAddress());
                    }
                } else {
                    byteBuf = this.newDirectBuffer(byteBuf);
                    assert (byteBuf.hasMemoryAddress());
                }
            }
            return byteBuf;
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf && (addressedEnvelope.recipient() == null || addressedEnvelope.recipient() instanceof InetSocketAddress)) {
            CompositeByteBuf compositeByteBuf;
            ByteBuf byteBuf = (ByteBuf)addressedEnvelope.content();
            if (byteBuf.hasMemoryAddress()) {
                return addressedEnvelope;
            }
            if (byteBuf instanceof CompositeByteBuf && (compositeByteBuf = (CompositeByteBuf)byteBuf).isDirect() && compositeByteBuf.nioBufferCount() <= Native.IOV_MAX) {
                return addressedEnvelope;
            }
            return new DefaultAddressedEnvelope<ByteBuf, InetSocketAddress>(this.newDirectBuffer(addressedEnvelope, byteBuf), (InetSocketAddress)addressedEnvelope.recipient());
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    @Override
    public EpollDatagramChannelConfig config() {
        return this.config;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.connected = false;
    }

    final class EpollDatagramChannelUnsafe
    extends AbstractEpollChannel.AbstractEpollUnsafe {
        private final List<Object> readBuf = new ArrayList<Object>();

        EpollDatagramChannelUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            boolean bl = false;
            try {
                try {
                    boolean bl2 = EpollDatagramChannel.this.isActive();
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    if (socketAddress2 != null) {
                        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)socketAddress2;
                        EpollDatagramChannel.this.doBind(inetSocketAddress2);
                    }
                    AbstractEpollChannel.checkResolvable(inetSocketAddress);
                    EpollDatagramChannel.this.remote = inetSocketAddress;
                    EpollDatagramChannel.this.local = EpollDatagramChannel.this.fd().localAddress();
                    bl = true;
                    channelPromise.trySuccess();
                    if (!bl2 && EpollDatagramChannel.this.isActive()) {
                        EpollDatagramChannel.this.pipeline().fireChannelActive();
                    }
                }
                finally {
                    if (!bl) {
                        EpollDatagramChannel.this.doClose();
                    } else {
                        EpollDatagramChannel.this.connected = true;
                    }
                }
            }
            catch (Throwable throwable) {
                channelPromise.tryFailure(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void epollInReady() {
            assert (EpollDatagramChannel.this.eventLoop().inEventLoop());
            if (EpollDatagramChannel.this.fd().isInputShutdown()) {
                this.clearEpollIn0();
                return;
            }
            EpollDatagramChannelConfig epollDatagramChannelConfig = EpollDatagramChannel.this.config();
            EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
            epollRecvByteAllocatorHandle.edgeTriggered(EpollDatagramChannel.this.isFlagSet(Native.EPOLLET));
            ChannelPipeline channelPipeline = EpollDatagramChannel.this.pipeline();
            ByteBufAllocator byteBufAllocator = epollDatagramChannelConfig.getAllocator();
            epollRecvByteAllocatorHandle.reset(epollDatagramChannelConfig);
            this.epollInBefore();
            Throwable throwable = null;
            try {
                ByteBuf byteBuf = null;
                try {
                    do {
                        DatagramSocketAddress datagramSocketAddress;
                        byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                        epollRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                        if (byteBuf.hasMemoryAddress()) {
                            datagramSocketAddress = EpollDatagramChannel.this.fd().recvFromAddress(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                        } else {
                            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                            datagramSocketAddress = EpollDatagramChannel.this.fd().recvFrom(byteBuffer, byteBuffer.position(), byteBuffer.limit());
                        }
                        if (datagramSocketAddress == null) {
                            epollRecvByteAllocatorHandle.lastBytesRead(-1);
                            byteBuf.release();
                            byteBuf = null;
                            break;
                        }
                        epollRecvByteAllocatorHandle.incMessagesRead(1);
                        epollRecvByteAllocatorHandle.lastBytesRead(datagramSocketAddress.receivedAmount());
                        byteBuf.writerIndex(byteBuf.writerIndex() + epollRecvByteAllocatorHandle.lastBytesRead());
                        this.readBuf.add(new DatagramPacket(byteBuf, (InetSocketAddress)this.localAddress(), datagramSocketAddress));
                        byteBuf = null;
                    } while (epollRecvByteAllocatorHandle.continueReading());
                }
                catch (Throwable throwable2) {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                    throwable = throwable2;
                }
                int n = this.readBuf.size();
                for (int i = 0; i < n; ++i) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead(this.readBuf.get(i));
                }
                this.readBuf.clear();
                epollRecvByteAllocatorHandle.readComplete();
                channelPipeline.fireChannelReadComplete();
                if (throwable != null) {
                    channelPipeline.fireExceptionCaught(throwable);
                }
            }
            finally {
                this.epollInFinally(epollDatagramChannelConfig);
            }
        }
    }
}

