/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.AbstractConstant;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new LinkedHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        this.childGroup = serverBootstrap.childGroup;
        this.childHandler = serverBootstrap.childHandler;
        Map<AbstractConstant, Object> map = serverBootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(serverBootstrap.childOptions);
        }
        map = serverBootstrap.childAttrs;
        synchronized (map) {
            this.childAttrs.putAll(serverBootstrap.childAttrs);
        }
    }

    @Override
    public ServerBootstrap group(EventLoopGroup eventLoopGroup) {
        return this.group(eventLoopGroup, eventLoopGroup);
    }

    public ServerBootstrap group(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2) {
        super.group(eventLoopGroup);
        if (eventLoopGroup2 == null) {
            throw new NullPointerException("childGroup");
        }
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = eventLoopGroup2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> channelOption, T t) {
        if (channelOption == null) {
            throw new NullPointerException("childOption");
        }
        if (t == null) {
            Map<ChannelOption<?>, Object> map = this.childOptions;
            synchronized (map) {
                this.childOptions.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            this.childOptions.put(channelOption, t);
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> attributeKey, T t) {
        if (attributeKey == null) {
            throw new NullPointerException("childKey");
        }
        if (t == null) {
            this.childAttrs.remove(attributeKey);
        } else {
            this.childAttrs.put(attributeKey, t);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler channelHandler) {
        if (channelHandler == null) {
            throw new NullPointerException("childHandler");
        }
        this.childHandler = channelHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(Channel channel) throws Exception {
        Map.Entry[] entryArray;
        Map.Entry[] entryArray2;
        Map<ChannelOption<?>, Object> map = this.options0();
        Map<AbstractConstant, Object> map2 = map;
        synchronized (map2) {
            channel.config().setOptions(map);
        }
        map2 = this.attrs0();
        Object object2 = map2;
        synchronized (object2) {
            for (Map.Entry<AbstractConstant, Object> object3 : map2.entrySet()) {
                entryArray2 = (Map.Entry[])object3.getKey();
                channel.attr(entryArray2).set(object3.getValue());
            }
        }
        object2 = channel.pipeline();
        final EventLoopGroup eventLoopGroup = this.childGroup;
        final ChannelHandler channelHandler = this.childHandler;
        Map<AbstractConstant, Object> map3 = this.childOptions;
        synchronized (map3) {
            entryArray2 = this.childOptions.entrySet().toArray(ServerBootstrap.newOptionArray(this.childOptions.size()));
        }
        map3 = this.childAttrs;
        synchronized (map3) {
            entryArray = this.childAttrs.entrySet().toArray(ServerBootstrap.newAttrArray(this.childAttrs.size()));
        }
        object2.addLast(new ChannelInitializer<Channel>(){

            @Override
            public void initChannel(Channel channel) throws Exception {
                final ChannelPipeline channelPipeline = channel.pipeline();
                ChannelHandler channelHandler2 = ServerBootstrap.this.config.handler();
                if (channelHandler2 != null) {
                    channelPipeline.addLast(channelHandler2);
                }
                channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        channelPipeline.addLast(new ServerBootstrapAcceptor(eventLoopGroup, channelHandler, entryArray2, entryArray));
                    }
                });
            }
        });
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    private static Map.Entry<ChannelOption<?>, Object>[] newOptionArray(int n) {
        return new Map.Entry[n];
    }

    private static Map.Entry<AttributeKey<?>, Object>[] newAttrArray(int n) {
        return new Map.Entry[n];
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    final Map<ChannelOption<?>, Object> childOptions() {
        return ServerBootstrap.copiedMap(this.childOptions);
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    private static class ServerBootstrapAcceptor
    extends ChannelInboundHandlerAdapter {
        private final EventLoopGroup childGroup;
        private final ChannelHandler childHandler;
        private final Map.Entry<ChannelOption<?>, Object>[] childOptions;
        private final Map.Entry<AttributeKey<?>, Object>[] childAttrs;

        ServerBootstrapAcceptor(EventLoopGroup eventLoopGroup, ChannelHandler channelHandler, Map.Entry<ChannelOption<?>, Object>[] entryArray, Map.Entry<AttributeKey<?>, Object>[] entryArray2) {
            this.childGroup = eventLoopGroup;
            this.childHandler = channelHandler;
            this.childOptions = entryArray;
            this.childAttrs = entryArray2;
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            final Channel channel = (Channel)object;
            channel.pipeline().addLast(this.childHandler);
            for (Map.Entry<ChannelOption<?>, Object> entry : this.childOptions) {
                try {
                    if (channel.config().setOption(entry.getKey(), entry.getValue())) continue;
                    logger.warn("Unknown channel option: " + entry);
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to set a channel option: " + channel, throwable);
                }
            }
            for (Map.Entry<AbstractConstant, Object> entry : this.childAttrs) {
                channel.attr((AttributeKey)entry.getKey()).set(entry.getValue());
            }
            try {
                this.childGroup.register(channel).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            ServerBootstrapAcceptor.forceClose(channel, channelFuture.cause());
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                ServerBootstrapAcceptor.forceClose(channel, throwable);
            }
        }

        private static void forceClose(Channel channel, Throwable throwable) {
            channel.unsafe().closeForcibly();
            logger.warn("Failed to register an accepted channel: " + channel, throwable);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            final ChannelConfig channelConfig = channelHandlerContext.channel().config();
            if (channelConfig.isAutoRead()) {
                channelConfig.setAutoRead(false);
                channelHandlerContext.channel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        channelConfig.setAutoRead(true);
                    }
                }, 1L, TimeUnit.SECONDS);
            }
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }
}

