/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import de.dal33t.powerfolder.util.StringUtils;
import edu.kit.scc.dei.ecplean.ECPAuthState;
import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.ECPAuthenticatorBase;
import edu.kit.scc.dei.ecplean.ECPUnauthorizedException;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ECPAuthenticator
extends ECPAuthenticatorBase {
    public ECPAuthenticator(String string, String string2, URI uRI, URI uRI2) {
        this(HttpClientBuilder.create(), string, string2, uRI, uRI2, null, null);
    }

    public ECPAuthenticator(HttpClientBuilder httpClientBuilder, String string, String string2, URI uRI, URI uRI2, String string3, String string4) {
        super(httpClientBuilder);
        this.authInfo = new ECPAuthenticationInfo(string, string2, uRI, uRI2, string3, string4);
        this.authInfo.setAuthState(ECPAuthState.NOT_STARTED);
    }

    public String[] authenticate() throws ECPAuthenticationException {
        String string;
        String string2;
        String string3;
        Document document;
        String string4;
        HttpResponse httpResponse;
        if (this.isInfo()) {
            LOG.fine("Starting authentication. Contacting SP " + this.authInfo.getSpUrl());
        }
        this.authInfo.setAuthState(ECPAuthState.INITIAL_PAOS_SP);
        this.setChanged();
        this.notifyObservers(this.authInfo);
        if (this.isFine()) {
            LOG.fine("Sending initial SP Request");
        }
        HttpGet httpGet = new HttpGet(this.authInfo.getSpUrl().toString());
        httpGet.setHeader("Accept", "text/html; application/vnd.paos+xml");
        httpGet.setHeader("PAOS", "ver='urn:liberty:paos:2003-08';'urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp'");
        try {
            httpResponse = this.getHttpClient().execute(httpGet);
            string4 = EntityUtils.toString(httpResponse.getEntity());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("responseBody: " + string4);
            }
        }
        catch (IOException | ParseException exception) {
            LOG.warning("Initial SP Request failed. " + exception);
            throw new ECPAuthenticationException(exception);
        }
        try {
            document = this.buildDocumentFromString(string4);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            LOG.warning("Parsing SP Request failed. " + exception + ". of content: " + string4);
            throw new ECPAuthenticationException(exception);
        }
        try {
            string3 = (String)this.queryDocument(document, "//ecp:RelayState", XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            LOG.warning("Could not find relay state in PAOS answer from SP. " + xPathException);
            throw new ECPAuthenticationException(xPathException);
        }
        if (this.isFine()) {
            LOG.fine("Got relayState: " + string3);
        }
        try {
            string2 = (String)this.queryDocument(document, "/S:Envelope/S:Header/paos:Request/@responseConsumerURL", XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            LOG.warning("Could not find response consumer url in PAOS answer from SP. " + xPathException);
            throw new ECPAuthenticationException(xPathException);
        }
        if (this.isFine()) {
            LOG.fine("Got responseConsumerUrl: " + string2);
        }
        Node node = document.getDocumentElement().getFirstChild();
        document.getDocumentElement().removeChild(node);
        Document document2 = this.authenticateIdP(document);
        try {
            string = (String)this.queryDocument(document2, "/S:Envelope/S:Header/ecp:Response/@AssertionConsumerServiceURL", XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            LOG.warning("Could not find assertion consumer url in answer from IdP. " + xPathException);
            throw new ECPAuthenticationException(xPathException);
        }
        if (this.isFine()) {
            LOG.fine("Got assertionConsumerUrl: " + string);
        }
        if (!string.equals(string2)) {
            throw new ECPAuthenticationException("Assertion- and ResponseConsumerURL don't match. responseConsumeUrl=" + string2 + ", assertionConsumerUrl=" + string);
        }
        document2.getDocumentElement().getFirstChild().getFirstChild().setTextContent(string3);
        if (this.isFine()) {
            LOG.fine("Sending Assertion to SP");
        }
        HttpPost httpPost = new HttpPost(string);
        httpPost.setHeader("Content-Type", "application/vnd.paos+xml");
        try {
            httpPost.setEntity(new StringEntity(this.documentToString(document2)));
            httpResponse = this.getHttpClient().execute(httpPost);
            string4 = EntityUtils.toString(httpResponse.getEntity());
        }
        catch (IOException | TransformerException | ParseException exception) {
            LOG.warning("Could not post assertion back to SP. " + exception);
            throw new ECPAuthenticationException(exception);
        }
        if (this.isInfo()) {
            LOG.fine("Requesting original URL: " + this.authInfo.getSpUrl());
        }
        httpGet = new HttpGet(this.authInfo.getSpUrl().toString());
        try {
            JSONObject jSONObject;
            httpResponse = this.getHttpClient().execute(httpGet);
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n != 200) {
                throw new ECPUnauthorizedException(n + " - " + httpResponse.getStatusLine().getReasonPhrase());
            }
            string4 = EntityUtils.toString(httpResponse.getEntity());
            if (this.isFine()) {
                LOG.fine("Got the following response from SP URL: " + this.authInfo.getSpUrl() + ":\n" + string4);
            }
            if (!(jSONObject = new JSONObject(string4)).has("shibboleth")) {
                throw new ECPAuthenticationException("Shibboleth login data not found in JSON response");
            }
            JSONObject jSONObject2 = jSONObject.getJSONObject("shibboleth");
            String string5 = jSONObject2.getString("sessionID");
            String string6 = jSONObject2.getString("persistentID");
            String string7 = jSONObject2.getString("eppn");
            String string8 = jSONObject2.getString("email");
            String string9 = jSONObject2.getString("username");
            String string10 = jSONObject2.getString("token");
            if (this.isInfo()) {
                LOG.fine("Shibboleth-Session-ID: " + string5);
                LOG.fine("Shibboleth-Persistent-ID: " + string6);
                LOG.fine("Shibboleth-EPPN: " + string7);
                LOG.fine("Shibboleth-Email: " + string8);
                LOG.fine("Shibboleth-Token: " + string10);
            }
            if (StringUtils.isBlank(string5)) {
                throw new ECPUnauthorizedException("Invalid Shibboleth session ID");
            }
            return new String[]{string9, string10};
        }
        catch (IOException | ParseException | JSONException exception) {
            LOG.warning("Could not request original URL: " + this.authInfo.getSpUrl() + " . " + exception);
            throw new ECPAuthenticationException(exception);
        }
    }
}

