/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import de.dal33t.powerfolder.util.logging.LoggingFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleHandler
extends Handler {
    private static ThreadLocal<LoggingFormatter> formatterThreadLocal = new ThreadLocal<LoggingFormatter>(){

        @Override
        protected LoggingFormatter initialValue() {
            return new LoggingFormatter();
        }
    };

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
        System.out.flush();
        System.err.flush();
    }

    @Override
    public void publish(LogRecord logRecord) {
        Object object;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        Object object2 = formatterThreadLocal.get().format(logRecord);
        if (logRecord.getParameters() != null && logRecord.getParameters().length >= 1 && logRecord.getParameters()[0] instanceof String) {
            object = (String)logRecord.getParameters()[0];
            while (((String)object).length() < 6) {
                object = (String)object + " ";
            }
            object2 = (String)object + " | " + (String)object2;
        }
        if (((Level)(object = logRecord.getLevel())).equals(Level.WARNING) || ((Level)object).equals(Level.SEVERE)) {
            System.err.print((String)object2);
        } else {
            System.out.print((String)object2);
        }
    }
}

