/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.delta.FilePartsState;
import de.dal33t.powerfolder.util.delta.MatchInfo;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.Callable;

public class MatchCopyWorker
extends Loggable
implements Callable<FilePartsState> {
    private final Path srcFile;
    private final Path dstFile;
    private final FilePartsRecord record;
    private final List<MatchInfo> matchInfoList;
    private FileChannel src;
    private FileChannel dst;
    private InputStream srcStream;
    private long srcStreamPos;
    private final ProgressListener progressObserver;

    public MatchCopyWorker(Path path, Path path2, FilePartsRecord filePartsRecord, List<MatchInfo> list, ProgressListener progressListener) {
        Reject.noNullElements(path, path2, filePartsRecord, list);
        this.srcFile = path;
        this.dstFile = path2;
        this.record = filePartsRecord;
        this.matchInfoList = list;
        this.progressObserver = progressListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilePartsState call() throws Exception {
        try {
            this.src = FileChannel.open(this.srcFile, StandardOpenOption.READ);
        }
        catch (Exception exception) {
            this.src = null;
            this.resetSrcStream();
        }
        try {
            FilePartsState filePartsState;
            this.dst = FileChannel.open(this.dstFile, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                FilePartsState filePartsState2 = new FilePartsState(this.record.getFileLength());
                int n = 0;
                for (MatchInfo matchInfo : this.matchInfoList) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.progressObserver != null) {
                        this.progressObserver.progressReached(this.matchInfoList.size() > 0 ? (double)n / (double)this.matchInfoList.size() : 1.0);
                    }
                    ++n;
                    if (this.src != null) {
                        this.src.position(matchInfo.getMatchedPosition());
                    } else {
                        if (this.srcStreamPos > matchInfo.getMatchedPosition()) {
                            this.resetSrcStream();
                        }
                        this.srcStream.skip(matchInfo.getMatchedPosition());
                        this.srcStreamPos += matchInfo.getMatchedPosition();
                    }
                    long l = matchInfo.getMatchedPart().getIndex() * (long)this.record.getPartLength();
                    this.dst.position(l);
                    int n2 = (int)Math.min((long)this.record.getPartLength(), this.record.getFileLength() - l);
                    if (this.src != null) {
                        PathUtils.ncopy(this.src, this.dst, n2);
                    } else {
                        PathUtils.ncopy(this.srcStream, this.dst, n2);
                    }
                    filePartsState2.setPartState(Range.getRangeByLength(l, n2), FilePartsState.PartState.AVAILABLE);
                }
                filePartsState = filePartsState2;
            }
            catch (Throwable throwable) {
                this.dst.close();
                throw throwable;
            }
            this.dst.close();
            return filePartsState;
        }
        finally {
            if (this.src != null) {
                this.src.close();
            } else {
                this.srcStream.close();
            }
        }
    }

    private void resetSrcStream() throws IOException {
        if (this.srcStream != null) {
            this.srcStream.close();
        }
        this.srcStream = Files.newInputStream(this.srcFile, new OpenOption[0]);
        this.srcStreamPos = 0L;
        if (this.isFine()) {
            this.logFine("Initialized InputStream instead of RAF for " + this.srcFile);
        }
    }
}

