/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.Partitions;
import de.dal33t.powerfolder.util.Range;
import java.io.Serializable;

public class FilePartsState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Partitions<PartState> parts;

    public FilePartsState(long l) {
        this.parts = new Partitions<PartState>(Range.getRangeByLength(0L, l), PartState.NEEDED);
    }

    public synchronized Range findPart(Range range, PartState partState) {
        return this.parts.search(range, partState);
    }

    public synchronized Range findFirstPart(PartState partState) {
        return this.findPart(this.parts.getPartionedRange(), partState);
    }

    public synchronized void setPartState(Range range, PartState partState) {
        this.parts.insert(range, partState);
    }

    public synchronized long countPartStates(Range range, PartState partState) {
        return this.parts.count(range, partState);
    }

    public synchronized void purgePending() {
        Range range;
        Range range2 = Range.getRangeByNumbers(0L, this.parts.getPartionedRange().getEnd());
        while ((range = this.findPart(range2, PartState.PENDING)) != null) {
            this.setPartState(range, PartState.NEEDED);
            range2 = Range.getRangeByNumbers(range.getEnd() + 1L, range2.getEnd());
        }
    }

    public long getFileLength() {
        return this.parts.getPartionedRange().getLength();
    }

    public Range getRange() {
        return this.parts.getPartionedRange();
    }

    public synchronized boolean isCompleted() {
        if (this.parts.getPartionedRange().getLength() == 0L) {
            return true;
        }
        Range range = this.parts.search(this.parts.getPartionedRange(), PartState.AVAILABLE);
        if (range == null) {
            return false;
        }
        return range.equals(this.parts.getPartionedRange());
    }

    public static enum PartState {
        NEEDED,
        PENDING,
        AVAILABLE;

    }
}

