/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.FilePartInfoListProto;
import de.dal33t.powerfolder.protocol.FilePartInfoProto;
import de.dal33t.powerfolder.util.delta.PartInfo;
import java.io.Serializable;
import java.util.Arrays;

public final class FilePartsRecord
implements Serializable,
D2DObject {
    private static final long serialVersionUID = 1L;
    private PartInfo[] infos;
    private int partLength;
    private long fileLength;
    private byte[] fileDigest;

    public FilePartsRecord(long l, PartInfo[] partInfoArray, int n, byte[] byArray) {
        this.partLength = n;
        this.infos = partInfoArray;
        this.fileDigest = byArray;
        this.fileLength = l;
    }

    public PartInfo[] getInfos() {
        return this.infos;
    }

    public int getPartLength() {
        return this.partLength;
    }

    public byte[] getFileDigest() {
        return this.fileDigest;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public boolean equals(Object object) {
        if (object.getClass() != FilePartsRecord.class) {
            return false;
        }
        FilePartsRecord filePartsRecord = (FilePartsRecord)object;
        return this.partLength == filePartsRecord.partLength && Arrays.equals(this.infos, filePartsRecord.infos) && Arrays.equals(this.fileDigest, filePartsRecord.fileDigest) && this.fileLength == filePartsRecord.fileLength;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fileDigest);
    }

    public String toString() {
        return "[FilePartsRecord, fsize: " + this.fileLength + ", partLength: " + this.partLength + ", infocount: " + this.infos.length + "]";
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FilePartInfoListProto.FilePartInfoList) {
            FilePartInfoListProto.FilePartInfoList filePartInfoList = (FilePartInfoListProto.FilePartInfoList)abstractMessage;
            int n = 0;
            this.infos = new PartInfo[filePartInfoList.getFilePartInfosCount()];
            for (FilePartInfoProto.FilePartInfo filePartInfo : filePartInfoList.getFilePartInfosList()) {
                this.infos[n++] = new PartInfo(filePartInfo);
            }
            this.partLength = filePartInfoList.getFilePartLength();
            this.fileLength = filePartInfoList.getFileLength();
            this.fileDigest = filePartInfoList.getFileDigest().toByteArray();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FilePartInfoListProto.FilePartInfoList.Builder builder = FilePartInfoListProto.FilePartInfoList.newBuilder();
        builder.setClazzName("FilePartInfoList");
        if (null != this.infos) {
            for (PartInfo partInfo : this.infos) {
                builder.addFilePartInfos((FilePartInfoProto.FilePartInfo)partInfo.toD2D());
            }
        }
        builder.setFilePartLength(this.partLength);
        builder.setFileLength(this.fileLength);
        builder.setFileDigest(ByteString.copyFrom(this.fileDigest));
        return builder.build();
    }
}

