/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.compare;

import de.dal33t.powerfolder.ui.information.folder.files.versions.FileInfoVersionTypeHolder;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Comparator;

public class FileInfoVersionTypeComparator
extends Loggable
implements Comparator<FileInfoVersionTypeHolder> {
    public static final int BY_VERSION_TYPE = 0;
    public static final int BY_VERSION = 1;
    public static final int BY_SIZE = 2;
    public static final int BY_MODIFIED_DATE = 3;
    private static final int BEFORE = -1;
    private static final int AFTER = 1;
    private int sortBy;
    private static final FileInfoVersionTypeComparator[] comparators = new FileInfoVersionTypeComparator[4];

    public FileInfoVersionTypeComparator(int n) {
        this.sortBy = n;
    }

    public static FileInfoVersionTypeComparator getComparator(int n) {
        return comparators[n];
    }

    @Override
    public int compare(FileInfoVersionTypeHolder fileInfoVersionTypeHolder, FileInfoVersionTypeHolder fileInfoVersionTypeHolder2) {
        switch (this.sortBy) {
            case 0: {
                if (fileInfoVersionTypeHolder.isOnline() && fileInfoVersionTypeHolder2.isOnline()) {
                    return 0;
                }
                if (!fileInfoVersionTypeHolder.isOnline() && !fileInfoVersionTypeHolder2.isOnline()) {
                    return 0;
                }
                return fileInfoVersionTypeHolder.isOnline() ? 1 : -1;
            }
            case 1: {
                if (fileInfoVersionTypeHolder.getFileInfo().getFolderInfo() == null && fileInfoVersionTypeHolder2.getFileInfo().getFolderInfo() == null) {
                    return 0;
                }
                if (fileInfoVersionTypeHolder.getFileInfo().getFolderInfo() == null) {
                    return -1;
                }
                if (fileInfoVersionTypeHolder2.getFileInfo().getFolderInfo() == null) {
                    return 1;
                }
                return fileInfoVersionTypeHolder.getFileInfo().getVersion() - fileInfoVersionTypeHolder2.getFileInfo().getVersion();
            }
            case 2: {
                if (fileInfoVersionTypeHolder.getFileInfo().getSize() < fileInfoVersionTypeHolder2.getFileInfo().getSize()) {
                    return -1;
                }
                if (fileInfoVersionTypeHolder.getFileInfo().getSize() > fileInfoVersionTypeHolder2.getFileInfo().getSize()) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                if (fileInfoVersionTypeHolder.getFileInfo().getModifiedDate() == null && fileInfoVersionTypeHolder2.getFileInfo().getModifiedDate() == null) {
                    return 0;
                }
                if (fileInfoVersionTypeHolder.getFileInfo().getModifiedDate() == null) {
                    return -1;
                }
                if (fileInfoVersionTypeHolder2.getFileInfo().getModifiedDate() == null) {
                    return 1;
                }
                return fileInfoVersionTypeHolder2.getFileInfo().getModifiedDate().compareTo(fileInfoVersionTypeHolder.getFileInfo().getModifiedDate());
            }
        }
        return 0;
    }

    static {
        FileInfoVersionTypeComparator.comparators[0] = new FileInfoVersionTypeComparator(0);
        FileInfoVersionTypeComparator.comparators[1] = new FileInfoVersionTypeComparator(1);
        FileInfoVersionTypeComparator.comparators[2] = new FileInfoVersionTypeComparator(2);
        FileInfoVersionTypeComparator.comparators[3] = new FileInfoVersionTypeComparator(3);
    }
}

