/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.collection;

import de.dal33t.powerfolder.util.collection.CompositeCollection;
import de.dal33t.powerfolder.util.collection.CompositeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CompositeMap<K, V>
implements Map<K, V> {
    private Map<K, V>[] composite;
    private MapMutator mutator;
    private static Integer INTEGER_ONE = 1;

    public CompositeMap() {
        this(new Map[]{null});
    }

    public CompositeMap(Map<K, V> ... mapArray) {
        this((MapMutator)null, mapArray);
    }

    public CompositeMap(MapMutator mapMutator, Map<K, V> ... mapArray) {
        this.mutator = mapMutator;
        this.composite = new Map[0];
        for (int i = mapArray.length - 1; i >= 0; --i) {
            this.addComposited(mapArray[i]);
        }
    }

    public void setMutator(MapMutator mapMutator) {
        this.mutator = mapMutator;
    }

    public synchronized void addComposited(Map map) throws IllegalArgumentException {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            Collection collection = CompositeMap.intersection(this.composite[i].keySet(), map.keySet());
            if (collection.size() == 0) continue;
            if (this.mutator == null) {
                throw new IllegalArgumentException("Key collision adding Map to CompositeMap");
            }
            this.mutator.resolveCollision(this, this.composite[i], map, collection);
        }
        Map[] mapArray = new Map[this.composite.length + 1];
        System.arraycopy(this.composite, 0, mapArray, 0, this.composite.length);
        mapArray[mapArray.length - 1] = map;
        this.composite = mapArray;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CompositeMap.getCardinalityMap(collection);
        Map map2 = CompositeMap.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        for (Object e : hashSet) {
            int n = Math.min(CompositeMap.getFreq(e, map), CompositeMap.getFreq(e, map2));
            for (int i = 0; i < n; ++i) {
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    private static final int getFreq(Object object, Map map) {
        Integer n = (Integer)map.get(object);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        for (Object e : collection) {
            Integer n = (Integer)hashMap.get(e);
            if (n == null) {
                hashMap.put(e, INTEGER_ONE);
                continue;
            }
            hashMap.put(e, n + 1);
        }
        return hashMap;
    }

    public synchronized Map removeComposited(Map map) {
        int n = this.composite.length;
        for (int i = 0; i < n; ++i) {
            if (!this.composite[i].equals(map)) continue;
            Map[] mapArray = new Map[n - 1];
            System.arraycopy(this.composite, 0, mapArray, 0, i);
            System.arraycopy(this.composite, i + 1, mapArray, i, n - i - 1);
            this.composite = mapArray;
            return map;
        }
        return null;
    }

    @Override
    public void clear() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            this.composite[i].clear();
        }
    }

    @Override
    public boolean containsKey(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsValue(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set entrySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeSet.addComposited(this.composite[i].entrySet());
        }
        return compositeSet;
    }

    @Override
    public V get(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return this.composite[i].get(object);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (this.composite[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set keySet() {
        CompositeSet compositeSet = new CompositeSet();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeSet.addComposited(this.composite[i].keySet());
        }
        return compositeSet;
    }

    @Override
    public Object put(Object object, Object object2) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        return this.mutator.put(this, this.composite, object, object2);
    }

    @Override
    public void putAll(Map map) {
        if (this.mutator == null) {
            throw new UnsupportedOperationException("No mutator specified");
        }
        this.mutator.putAll(this, this.composite, map);
    }

    @Override
    public V remove(Object object) {
        for (int i = this.composite.length - 1; i >= 0; --i) {
            if (!this.composite[i].containsKey(object)) continue;
            return this.composite[i].remove(object);
        }
        return null;
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = this.composite.length - 1; i >= 0; --i) {
            n += this.composite[i].size();
        }
        return n;
    }

    @Override
    public Collection values() {
        CompositeCollection compositeCollection = new CompositeCollection();
        for (int i = this.composite.length - 1; i >= 0; --i) {
            compositeCollection.addComposited((Collection)this.composite[i].values());
        }
        return compositeCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public static interface MapMutator {
        public void resolveCollision(CompositeMap var1, Map var2, Map var3, Collection var4);

        public Object put(CompositeMap var1, Map[] var2, Object var3, Object var4);

        public void putAll(CompositeMap var1, Map[] var2, Map var3);
    }
}

