/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.MessageListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public class MessageListenerSupport
extends Loggable {
    private static final boolean AWT_AVAILABLE = Util.isAwtAvailable();
    private Loggable source;
    private final Map<Class<?>, CopyOnWriteArrayList<MessageListener>> messageListenersInDispatchThread;
    private final Map<Class<?>, CopyOnWriteArrayList<MessageListener>> messageListenersNotInDispatchThread;

    public MessageListenerSupport(Loggable loggable) {
        this.source = loggable;
        Reject.ifNull(loggable, "Source");
        this.messageListenersNotInDispatchThread = new ConcurrentHashMap(2, 0.75f, 8);
        this.messageListenersInDispatchThread = new ConcurrentHashMap(2, 0.75f, 8);
    }

    public void addMessageListener(MessageListener messageListener) {
        this.addMessageListener(All.class, messageListener);
    }

    public synchronized void addMessageListener(Class<?> clazz, MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        CopyOnWriteArrayList<MessageListener> copyOnWriteArrayList = messageListener.fireInEventDispatchThread() ? this.messageListenersInDispatchThread.get(clazz) : this.messageListenersNotInDispatchThread.get(clazz);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            if (messageListener.fireInEventDispatchThread()) {
                this.messageListenersInDispatchThread.put(clazz, copyOnWriteArrayList);
            } else {
                this.messageListenersNotInDispatchThread.put(clazz, copyOnWriteArrayList);
            }
        }
        copyOnWriteArrayList.addIfAbsent(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(MessageListener messageListener) {
        if (messageListener.fireInEventDispatchThread()) {
            Map<Class<?>, CopyOnWriteArrayList<MessageListener>> map = this.messageListenersInDispatchThread;
            synchronized (map) {
                for (Collection collection : this.messageListenersInDispatchThread.values()) {
                    collection.remove(messageListener);
                }
            }
        }
        Map<Class<?>, CopyOnWriteArrayList<MessageListener>> map = this.messageListenersNotInDispatchThread;
        synchronized (map) {
            for (Collection collection : this.messageListenersNotInDispatchThread.values()) {
                collection.remove(messageListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Map<Class<?>, CopyOnWriteArrayList<MessageListener>> map = this.messageListenersInDispatchThread;
        synchronized (map) {
            for (Collection collection : this.messageListenersInDispatchThread.values()) {
                collection.clear();
            }
        }
        map = this.messageListenersNotInDispatchThread;
        synchronized (map) {
            for (Collection collection : this.messageListenersNotInDispatchThread.values()) {
                collection.clear();
            }
        }
    }

    public void fireMessage(Member member, Message message) {
        boolean bl;
        Object object;
        Object object2;
        Object object32;
        if (message == null) {
            return;
        }
        if (member == null) {
            throw new NullPointerException("Unable to fire message, source is null");
        }
        Collection collection = this.messageListenersNotInDispatchThread.get(All.class);
        if (collection != null && !collection.isEmpty()) {
            for (Object object32 : collection) {
                try {
                    object32.handleMessage(member, message);
                }
                catch (Exception exception) {
                    this.logWarning(this.source + ": Exception while handling message in listener of " + member + ". msg: " + message + ". " + exception, exception);
                }
            }
        }
        Class<Object> clazz = message.getClass();
        do {
            if ((object32 = (Collection)this.messageListenersNotInDispatchThread.get(clazz)) == null || object32.isEmpty()) continue;
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (MessageListener)object2.next();
                try {
                    object.handleMessage(member, message);
                }
                catch (Exception exception) {
                    this.logWarning(this.source + ": Exception while handling message in listener of " + member + ". msg: " + message + ". " + exception, exception);
                }
            }
        } while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Message.class) && !clazz.equals(Object.class));
        object32 = this.messageListenersInDispatchThread.get(All.class);
        object2 = null;
        clazz = message.getClass();
        do {
            if ((object = (List)this.messageListenersInDispatchThread.get(clazz)) == null || object.isEmpty()) continue;
            if (object2 == null) {
                object2 = new LinkedList(object);
                continue;
            }
            object2.addAll(object);
        } while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Message.class) && !clazz.equals(Object.class));
        boolean bl2 = bl = object32 != null && !object32.isEmpty() || object2 != null && !object2.isEmpty();
        if (!bl) {
            return;
        }
        Object object4 = object2;
        Runnable runnable = () -> this.lambda$fireMessage$0((List)object32, member, message, (List)object4);
        if (!AWT_AVAILABLE || EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private /* synthetic */ void lambda$fireMessage$0(List list, Member member, Message message, List list2) {
        if (list != null && !list.isEmpty()) {
            for (MessageListener messageListener : list) {
                try {
                    messageListener.handleMessage(member, message);
                }
                catch (Exception exception) {
                    this.logWarning(this.source + ": Exception while handling message in listener of " + member + ". msg: " + message + ". " + exception, exception);
                }
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            for (MessageListener messageListener : list2) {
                try {
                    messageListener.handleMessage(member, message);
                }
                catch (Exception exception) {
                    this.logWarning(this.source + ": Exception while handling message in listener of " + member + ". msg: " + message + ". " + exception, exception);
                }
            }
        }
    }

    private static class All {
        private All() {
        }
    }
}

