/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Translation;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;

public class Format {
    private static final CanonicalDateFormat CANONICAL_DATE_FORMAT = new CanonicalDateFormat();
    private static Pattern CANONICAL_DATE_PATTERN = Pattern.compile("^\\d{2} \\w{3} \\d{4}$");
    private static final CanonicalDateWithTimeFormat CANONICAL_DATE_WITH_TIME_FORMAT = new CanonicalDateWithTimeFormat();
    private static final ShortDateFormat SHORT_DATE_FORMAT = new ShortDateFormat();
    private static final ShortTimeFormat SHORT_TIME_FORMAT = new ShortTimeFormat();
    private static final LongTimeFormat LONG_TIME_FORMAT = new LongTimeFormat();
    private static final DoubleNumberFormat DOUBLE_NUMBER_FORMAT = new DoubleNumberFormat();
    private static final LongNumberFormat LONG_NUMBER_FORMAT = new LongNumberFormat();
    private static final PercentNumberFormat PERCENT_NUMBER_FORMAT = new PercentNumberFormat();

    private Format() {
    }

    public static String formatBytes(long l) {
        double d = l;
        String string = "Bytes";
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "kBytes";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "MBytes";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "GBytes";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "TBytes";
        }
        String string2 = Format.formatDecimal(d);
        return string2 + " " + string;
    }

    public static String formatBytesShort(long l) {
        double d = l;
        String string = "B";
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "kB";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "MB";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "GB";
        }
        if (d >= 1024.0) {
            d /= 1024.0;
            string = "TB";
        }
        String string2 = Format.formatDecimal(d);
        if (d < 0.0) {
            string2 = "??";
        }
        return string2 + " " + string;
    }

    public static String formatTimeframe(long l) {
        if (l < 2000L) {
            return String.valueOf(l) + "ms";
        }
        if (l < 120000L) {
            return String.valueOf(l / 1000L) + "s";
        }
        if (l < 0x6DDD00L) {
            return String.valueOf(l / 1000L / 60L) + "m";
        }
        if (l < 172800000L) {
            return String.valueOf(l / 1000L / 60L / 60L) + "h";
        }
        return String.valueOf(l / 1000L / 60L / 60L / 24L) + "d";
    }

    public static String formatTimeLong(Date date) {
        if (date == null) {
            return null;
        }
        return ((DateFormat)LONG_TIME_FORMAT.get()).format(date);
    }

    public static String formatTimeShort(Date date) {
        if (date == null) {
            return null;
        }
        return ((DateFormat)SHORT_TIME_FORMAT.get()).format(date);
    }

    public static String formatDateCanonical(Date date) {
        return ((DateFormat)CANONICAL_DATE_FORMAT.get()).format(date);
    }

    public static boolean isCanonicalDate(String string) {
        return CANONICAL_DATE_PATTERN.matcher(string).matches();
    }

    public static String formatDateWithTimeCanonical(Date date) {
        return ((DateFormat)CANONICAL_DATE_WITH_TIME_FORMAT.get()).format(date);
    }

    public static Date parseDateCanonical(String string) throws ParseException {
        return ((DateFormat)CANONICAL_DATE_FORMAT.get()).parse(string);
    }

    public static Date parseJsonDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return simpleDateFormat.parse(string);
    }

    public static String formatDateShort(Date date) {
        return Format.formatDateShort(date, true);
    }

    public static String formatDateShort(Date date, boolean bl) {
        Object object;
        if (date == null) {
            return null;
        }
        if (bl) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(date);
            Calendar calendar = Calendar.getInstance();
            if (((Calendar)object).get(1) == calendar.get(1)) {
                int n = ((Calendar)object).get(6) - calendar.get(6);
                if (n == 0) {
                    return Translation.get("general.today") + " " + Format.formatTimeShort(date);
                }
                if (n == -1) {
                    return Translation.get("general.yesterday") + " " + Format.formatTimeShort(date);
                }
                if (n == 1) {
                    return Translation.get("general.tomorrow") + " " + Format.formatTimeShort(date);
                }
            }
        }
        object = ((DateFormat)SHORT_DATE_FORMAT.get()).format(date);
        return ((String)object).replaceAll(",", "");
    }

    public static String formatDecimal(double d) {
        return ((NumberFormat)DOUBLE_NUMBER_FORMAT.get()).format(d);
    }

    public static String formatLong(long l) {
        return ((NumberFormat)LONG_NUMBER_FORMAT.get()).format(l);
    }

    public static String formatPercent(double d) {
        if (d > 100.0) {
            return "100%";
        }
        String string = ((NumberFormat)PERCENT_NUMBER_FORMAT.get()).format(d / 100.0);
        if (d != 100.0 && string.equals("100%")) {
            string = "99%";
        }
        return string;
    }

    public static String formatBoolean(boolean bl) {
        return bl ? Translation.get("general.yes") : Translation.get("general.no");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDeltaTime(long l) {
        try (Formatter formatter = new Formatter();){
            long l2 = l / 24L / 3600L / 1000L;
            if (l2 >= 2L) {
                String string = formatter.format(Translation.get("format.n.days", String.valueOf(l2)), new Object[0]).out().toString();
                return string;
            }
            long l3 = l / 3600L / 1000L;
            if (l3 >= 2L) {
                String string = formatter.format(Translation.get("format.n.hours", String.valueOf(l3)), new Object[0]).out().toString();
                return string;
            }
            long l4 = l / 60L / 1000L;
            if (l4 > 1L) {
                String string = formatter.format(Translation.get("format.n.minutes", String.valueOf(l4)), new Object[0]).out().toString();
                return string;
            }
            if (l4 == 1L) {
                String string = formatter.format(Translation.get("format.one_minute"), new Object[0]).out().toString();
                return string;
            }
            String string = formatter.format(Translation.get("format.less_than_one_minute"), new Object[0]).out().toString();
            return string;
        }
    }

    private static class LongTimeFormat
    extends ThreadLocal<DateFormat> {
        private LongTimeFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getTimeInstance(1);
        }
    }

    private static class ShortTimeFormat
    extends ThreadLocal<DateFormat> {
        private ShortTimeFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getTimeInstance(3);
        }
    }

    private static class CanonicalDateFormat
    extends ThreadLocal<DateFormat> {
        private CanonicalDateFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
        }
    }

    private static class CanonicalDateWithTimeFormat
    extends ThreadLocal<DateFormat> {
        private CanonicalDateWithTimeFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.ENGLISH);
        }
    }

    private static class ShortDateFormat
    extends ThreadLocal<DateFormat> {
        private ShortDateFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            return DateFormat.getDateTimeInstance(3, 3);
        }
    }

    private static class DoubleNumberFormat
    extends ThreadLocal<NumberFormat> {
        private DoubleNumberFormat() {
        }

        @Override
        protected NumberFormat initialValue() {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            return numberFormat;
        }
    }

    private static class LongNumberFormat
    extends ThreadLocal<NumberFormat> {
        private LongNumberFormat() {
        }

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getIntegerInstance();
        }
    }

    private static class PercentNumberFormat
    extends ThreadLocal<NumberFormat> {
        private PercentNumberFormat() {
        }

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getPercentInstance();
        }
    }
}

