/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Debug;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;

public class FolderDBDebug {
    public static void main(String[] stringArray) throws IOException, ClassNotFoundException {
        Object object = stringArray.length < 1 ? "PowerFolder.db" : stringArray[0];
        if (!((String)object).contains(".")) {
            object = (String)object + ".db";
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object));
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        FileInfo[] fileInfoArray = (FileInfo[])objectInputStream.readObject();
        System.err.println(objectInputStream.readObject());
        System.err.println(objectInputStream.readObject());
        objectInputStream.close();
        if (!FolderDBDebug.checkForDupes(fileInfoArray)) {
            System.out.println("OK: DB contain NO dupes.");
        }
        FolderInfo folderInfo = fileInfoArray.length > 0 ? fileInfoArray[0].getFolderInfo() : null;
        String string = folderInfo != null ? folderInfo.getLocalizedName() : "-unknown-";
        String string2 = folderInfo != null ? folderInfo.getId() : "-unknown-";
        long l = 0L;
        for (FileInfo fileInfo : fileInfoArray) {
            if (fileInfo.isDeleted()) continue;
            l += fileInfo.getSize();
        }
        Path path = Paths.get((String)object + ".csv", new String[0]);
        Path path2 = Debug.writeFileListCSV(path, Arrays.asList(fileInfoArray), "FileList of folder " + string + "/" + string2);
        System.out.println("Read " + fileInfoArray.length + " files (" + Format.formatBytesShort(l) + ") from " + (String)object + ". \nOutput: " + path2.toRealPath(new LinkOption[0]));
        PathUtils.openFile(path2);
    }

    private static boolean checkForDupes(FileInfo[] fileInfoArray) {
        boolean bl = false;
        HashMap<String, FileInfo> hashMap = new HashMap<String, FileInfo>();
        for (FileInfo fileInfo : fileInfoArray) {
            if (hashMap.containsKey(fileInfo.getRelativeName().toLowerCase())) {
                bl = true;
                System.err.println("Detected dupe: " + fileInfo.toDetailString() + " of " + ((FileInfo)hashMap.get(fileInfo.getRelativeName().toLowerCase())).toDetailString());
            }
            hashMap.put(fileInfo.getRelativeName().toLowerCase(), fileInfo);
        }
        return bl;
    }
}

