/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.PropertiesUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderConfigRestore {
    private static final Logger LOG = Logger.getLogger(FolderConfigRestore.class.getName());

    public static void main(String[] stringArray) throws IOException {
        Properties properties = new Properties();
        Path path = Paths.get(stringArray[0], new String[0]);
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
        for (Path path2 : directoryStream) {
            Path path3 = path2.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR);
            LOG.info("Processing directory: " + path2);
            if (Files.exists(path3, new LinkOption[0])) {
                try {
                    FolderConfigRestore.restoreFolderConfig(path2, properties);
                }
                catch (Exception exception) {
                    LOG.warning("Problem with " + path2 + ". " + exception);
                }
                continue;
            }
            if (!Files.isDirectory(path2, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path2);
                try {
                    for (Path path4 : directoryStream2) {
                        if (!Files.isDirectory(path4, new LinkOption[0])) continue;
                        try {
                            FolderConfigRestore.restoreFolderConfig(path4, properties);
                        }
                        catch (Exception exception) {
                            LOG.warning("Problem with " + path4 + ". " + exception);
                        }
                    }
                }
                finally {
                    if (directoryStream2 == null) continue;
                    directoryStream2.close();
                }
            }
            catch (Exception exception) {
                LOG.warning("Problem with " + path2 + ". " + exception);
            }
        }
        PropertiesUtil.saveConfig(Paths.get("PowerFolder_restored.config", new String[0]), properties, "");
    }

    private static void restoreFolderConfig(Path path, Properties properties) {
        FolderInfo folderInfo;
        path = PathUtils.removeInvalidFilenameChars(path);
        try {
            folderInfo = FolderConfigRestore.readFolderInfo(path);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Unable to read folder info from " + path + ". " + exception);
            return;
        }
        if (folderInfo == null) {
            LOG.severe("Unable to read folderinfo from " + path);
            return;
        }
        FolderSettings folderSettings = new FolderSettings(path, SyncProfile.AUTOMATIC_SYNCHRONIZATION, 0);
        folderSettings.set(folderInfo, properties);
        LOG.info("Restored folder " + folderInfo.getName() + " @ " + path);
    }

    private static FolderInfo readFolderInfo(Path path) throws IOException, ClassNotFoundException {
        Path path2 = path.resolve(Constants.POWERFOLDER_SYSTEM_SUBDIR);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new FileNotFoundException("No folder found at " + path2);
        }
        Path path3 = path2.resolve(Constants.DB_FILENAME);
        ObjectInputStream objectInputStream = new ObjectInputStream(Files.newInputStream(path3, new OpenOption[0]));
        FileInfo[] fileInfoArray = (FileInfo[])objectInputStream.readObject();
        if (fileInfoArray.length <= 0) {
            return null;
        }
        return fileInfoArray[0].getFolderInfo();
    }
}

