/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    private long readBytes;

    public CountedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            ++this.readBytes;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.readBytes += (long)n3;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.readBytes += l2;
        return l2;
    }

    public long getReadBytes() {
        return this.readBytes;
    }
}

