/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class AddLicenseHeader {
    private static final String LIC_INFO = "/*\r\n* Copyright 2004 - 2008 Christian Sprajc. All rights reserved.\r\n*\r\n* This file is part of PowerFolder.\r\n*\r\n* PowerFolder is free software: you can redistribute it and/or modify\r\n* it under the terms of the GNU General Public License as published by\r\n* the Free Software Foundation.\r\n*\r\n* PowerFolder is distributed in the hope that it will be useful,\r\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\n* GNU General Public License for more details.\r\n*\r\n* You should have received a copy of the GNU General Public License\r\n* along with PowerFolder. If not, see <http://www.gnu.org/licenses/>.\r\n*\r\n* $Id: AddLicenseHeader.java 4282 2008-06-16 03:25:09Z tot $\r\n*/\r\n";
    private static final String LIC_INFO_DENNIS = "/*\r\n* Copyright 2004 - 2008 Christian Sprajc, Dennis Waldherr. All rights reserved.\r\n*\r\n* This file is part of PowerFolder.\r\n*\r\n* PowerFolder is free software: you can redistribute it and/or modify\r\n* it under the terms of the GNU General Public License as published by\r\n* the Free Software Foundation.\r\n*\r\n* PowerFolder is distributed in the hope that it will be useful,\r\n* but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\n* GNU General Public License for more details.\r\n*\r\n* You should have received a copy of the GNU General Public License\r\n* along with PowerFolder. If not, see <http://www.gnu.org/licenses/>.\r\n*\r\n* $Id: AddLicenseHeader.java 4282 2008-06-16 03:25:09Z tot $\r\n*/\r\n";

    public static void main(String[] stringArray) {
        AddLicenseHeader.addLicInfoToDir(Paths.get(".", new String[0]));
    }

    public static void addLicInfoToDir(Path path) {
        DirectoryStream<Path> directoryStream;
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return path.getFileName().toString().endsWith(".java");
            }
        };
        try {
            directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);
            try {
                for (Path path2 : directoryStream) {
                    AddLicenseHeader.addLicInfo(path2);
                }
            }
            finally {
                if (directoryStream != null) {
                    directoryStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return Files.isDirectory(path, new LinkOption[0]);
            }
        };
        try {
            directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);
            try {
                for (Path path2 : directoryStream) {
                    AddLicenseHeader.addLicInfoToDir(path2);
                }
            }
            finally {
                if (directoryStream != null) {
                    directoryStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void addLicInfo(Path path) {
        try {
            if (path.toAbsolutePath().toString().contains("\\jwf\\jwf")) {
                System.out.println("Skip: " + path.toRealPath(new LinkOption[0]));
                return;
            }
            if (path.toAbsolutePath().toString().contains("org\\jdesktop\\swinghelper")) {
                System.out.println("Skip: " + path.toRealPath(new LinkOption[0]));
                return;
            }
            Object object = FileUtils.readFileToString(path.toFile(), "UTF-8");
            int n = ((String)object).indexOf("package");
            boolean bl = ((String)object).contains("@author Dennis");
            if (bl) {
                System.err.println("Dennis: " + path.toRealPath(new LinkOption[0]) + ": " + n);
                object = LIC_INFO_DENNIS + ((String)object).substring(n, ((String)object).length());
            } else {
                System.out.println("Onlyme: " + path.toRealPath(new LinkOption[0]) + ": " + n);
                object = LIC_INFO + ((String)object).substring(n, ((String)object).length());
            }
            FileUtils.writeStringToFile(path.toFile(), (String)object, "UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

