/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard.table;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.render.SortedTableHeaderRenderer;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.wizard.table.MultiFileRestoreTableModel;
import de.dal33t.powerfolder.util.Format;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MultiFileRestoreTable
extends JTable {
    public MultiFileRestoreTable(MultiFileRestoreTableModel multiFileRestoreTableModel) {
        super(multiFileRestoreTableModel);
        this.setRowHeight(Icons.getIconById("node_friend_connected.icon").getIconHeight() + 3);
        this.setColumnSelectionAllowed(false);
        this.setShowGrid(false);
        this.setupColumns();
        this.setDefaultRenderer(FileInfo.class, new MyDefaultTreeCellRenderer());
        this.getTableHeader().addMouseListener(new TableHeaderMouseListener());
        SortedTableHeaderRenderer.associateHeaderRenderer(multiFileRestoreTableModel, this.getColumnModel(), 0, true);
    }

    private void setupColumns() {
        int n = this.getWidth();
        this.getTableHeader().setPreferredSize(new Dimension(n, 20));
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.getColumn(this.getColumnName(1));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.getColumn(this.getColumnName(2));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.getColumn(this.getColumnName(3));
        tableColumn.setPreferredWidth(60);
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FileInfo fileInfo = (FileInfo)object;
            this.setIcon(null);
            String string = "";
            switch (n2) {
                case 0: {
                    string = fileInfo.getFilenameOnly();
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    string = Format.formatDateShort(fileInfo.getModifiedDate());
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 2: {
                    string = Format.formatLong(fileInfo.getVersion());
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 3: {
                    string = Format.formatBytesShort(fileInfo.getSize());
                    this.setHorizontalAlignment(4);
                }
            }
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            if (!bl) {
                this.setBackground(n % 2 == 0 ? ColorUtil.EVEN_TABLE_ROW_COLOR : ColorUtil.ODD_TABLE_ROW_COLOR);
            }
            return component;
        }
    }

    private static class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MultiFileRestoreTableModel multiFileRestoreTableModel;
                boolean bl;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
                TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                TableModel tableModel = jTableHeader.getTable().getModel();
                if (tableModel instanceof MultiFileRestoreTableModel && !(bl = (multiFileRestoreTableModel = (MultiFileRestoreTableModel)tableModel).sortBy(n2))) {
                    multiFileRestoreTableModel.reverseList();
                }
            }
        }
    }
}

