/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.LayoutMap;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.AntialiasedLabel;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jwf.WizardPanel;

public abstract class PFWizardPanel
extends WizardPanel {
    private Controller controller;
    private boolean initalized;
    private JLabel titleLabel;

    protected PFWizardPanel(Controller controller) {
        if (controller == null) {
            throw new NullPointerException("Controller is null");
        }
        this.controller = controller;
        this.setOpaque(false);
        LayoutMap.getRoot().columnPut("wlabel", "70dlu");
        LayoutMap.getRoot().columnPut("wfield", "100dlu");
    }

    @Override
    public final synchronized void display() {
        if (!this.initalized) {
            this.buildUI();
        }
        this.afterDisplay();
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public boolean validateNext() {
        return true;
    }

    @Override
    public boolean validateFinish() {
        return true;
    }

    @Override
    public void finish() {
    }

    protected abstract JComponent buildContent();

    protected void afterDisplay() {
    }

    protected abstract String getTitle();

    protected abstract void initComponents();

    @Override
    public boolean hasHelp() {
        return StringUtils.isNotBlank(ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(this.getController()));
    }

    @Override
    public void help() {
        Help.openQuickstartGuides(this.controller);
    }

    private static JLabel createTitleLabel(String string) {
        AntialiasedLabel antialiasedLabel = new AntialiasedLabel(string);
        SimpleComponentFactory.setFontSize(antialiasedLabel, 20);
        return antialiasedLabel;
    }

    protected void updateTitle() {
        if (this.titleLabel == null) {
            return;
        }
        this.titleLabel.setText(this.getTitle());
    }

    protected Controller getController() {
        return this.controller;
    }

    private void buildUI() {
        this.initComponents();
        JComponent jComponent = this.buildContent();
        jComponent.setOpaque(false);
        String string = this.getTitle();
        Reject.ifBlank(string, "Title is blank");
        Reject.ifNull(jComponent, "Content is null");
        this.setBorder(Borders.EMPTY_BORDER);
        FormLayout formLayout = new FormLayout("13px, fill:pref:grow", "pref, 7dlu, pref, 3dlu, fill:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, this);
        panelBuilder.setBorder(Borders.createEmptyBorder("7dlu, 20dlu, 0dlu, 20dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)new JLabel(Icons.getIconById("power_folder_logo_400_ui.icon")), cellConstraints.xywh(1, n, 2, 1, "left, default"));
        this.titleLabel = PFWizardPanel.createTitleLabel(string);
        panelBuilder.add((Component)this.titleLabel, cellConstraints.xy(2, n += 2));
        panelBuilder.add((Component)jComponent, cellConstraints.xy(2, n += 2, CellConstraints.DEFAULT, CellConstraints.TOP));
        this.initalized = true;
    }
}

