/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.message.clientserver.AccountDetails;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.ActivityVisualizationWorker;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class FileSyncSetupPanel
extends PFWizardPanel {
    private static final Logger LOG = Logger.getLogger(FileSyncSetupPanel.class.getName());
    private JRadioButton syncThisComRadioButton;
    private JRadioButton syncNetDriveRadioButton;
    private JComponent locationField;
    private JTextField syncNetDriveField;
    private JTextField locationTF;
    private ValueModel locationModel;
    private WizardPanel nextFinishPanel;
    private ServerClient serverClient;
    private String webDAVURL;
    private Date lastFetch;

    public FileSyncSetupPanel(Controller controller, ServerClient serverClient, WizardPanel wizardPanel) {
        super(controller);
        Reject.ifNull(wizardPanel, "NextFinishPanel is null");
        this.serverClient = serverClient;
        this.nextFinishPanel = wizardPanel;
    }

    @Override
    protected void afterDisplay() {
        super.afterDisplay();
        if (!this.getController().getOSClient().supportsWebDAV()) {
            this.syncNetDriveRadioButton.setEnabled(false);
        } else if (PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            this.syncNetDriveRadioButton.setSelected(true);
            this.getWizard().next();
            return;
        }
        if (this.getController().getFolderRepository().getFoldersCount() > 0) {
            this.getWizard().next();
            return;
        }
        AccountDetails accountDetails = this.serverClient.getAccountDetails();
        if (accountDetails.getAccount().isValid() && this.getController().getFolderRepository().sufficientDiskSpaceAvailable(accountDetails)) {
            this.getWizard().next();
        }
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public WizardPanel next() {
        if (this.syncNetDriveRadioButton.isSelected()) {
            return new SwingWorkerPanel(this.getController(), new WebDAVConnectionTask(), Translation.get("wizard.login_online_storage.logging_in"), Translation.get("wizard.login_online_storage.logging_in.text"), this.nextFinishPanel);
        }
        return this.nextFinishPanel;
    }

    @Override
    public boolean canCancel() {
        return false;
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.file_sync.title");
    }

    @Override
    protected void initComponents() {
        this.syncThisComRadioButton = new JRadioButton(Translation.get("wizard.file_sync.local"));
        this.syncNetDriveRadioButton = new JRadioButton(Translation.get("wizard.file_sync.network"));
        this.syncThisComRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.syncThisComRadioButton);
        buttonGroup.add(this.syncNetDriveRadioButton);
        this.locationModel = new ValueHolder(this.getController().getFolderRepository().getFoldersBasedirString());
        this.locationModel.addValueChangeListener(propertyChangeEvent -> this.updateLocationComponents());
        this.locationField = this.createLocationField();
        this.syncNetDriveField = new JTextField();
    }

    @Override
    protected JComponent buildContent() {
        FormLayout formLayout = new FormLayout("left:40dlu, 3dlu, 120dlu:grow", "pref");
        final PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)this.syncThisComRadioButton, cellConstraints.xyw(1, n, 3));
        panelBuilder.appendUnrelatedComponentsGapRow();
        panelBuilder.appendRow("top:20dlu");
        final JLabel jLabel = new JLabel(Translation.get("wizard.file_sync.location_label"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.locationField, cellConstraints.xy(3, n));
        panelBuilder.appendUnrelatedComponentsGapRow();
        panelBuilder.appendRow("pref");
        panelBuilder.add((Component)this.syncNetDriveRadioButton, cellConstraints.xyw(1, n += 2, 3));
        this.syncThisComRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray;
                jLabel.setVisible(true);
                for (Component component : componentArray = panelBuilder.getPanel().getComponents()) {
                    String string = component.getName();
                    if (string == null || !string.equals("locationField")) continue;
                    component.setVisible(true);
                }
            }
        });
        this.syncNetDriveRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray;
                jLabel.setVisible(false);
                for (Component component : componentArray = panelBuilder.getPanel().getComponents()) {
                    String string = component.getName();
                    if (string == null || !string.equals("locationField")) continue;
                    component.setVisible(false);
                }
            }
        });
        return panelBuilder.getPanel();
    }

    private void disableLocalSync() {
        ConfigurationEntry.AUTO_SETUP_ACCOUNT_FOLDERS.setValue(this.getController(), false);
        ConfigurationEntry.LOOK_FOR_FOLDER_CANDIDATES.setValue(this.getController(), false);
        this.getController().saveConfig();
    }

    private void createWebdavConnection() {
        ActivityVisualizationWorker activityVisualizationWorker = new ActivityVisualizationWorker(this.getController().getUIController()){

            @Override
            protected String getTitle() {
                return Translation.get("exp_folder_view.webdav_title");
            }

            @Override
            protected String getWorkingText() {
                return Translation.get("exp_folder_view.webdav_working_text");
            }

            @Override
            public Object construct() throws Throwable {
                try {
                    FileSyncSetupPanel.this.webDAVURL = FileSyncSetupPanel.this.serverClient.getWebURL("/webdav", false);
                    if (OSUtil.isLinux()) {
                        return LinuxUtil.mountWebDAV(FileSyncSetupPanel.this.serverClient, FileSyncSetupPanel.this.webDAVURL);
                    }
                    if (OSUtil.isMacOS()) {
                        return "NUnsupported";
                    }
                    char c = FileSyncSetupPanel.this.getController().getDistribution().getBinaryName().charAt(0);
                    if (WinUtils.isWebDAVAlreadyMapped(FileSyncSetupPanel.this.serverClient, c)) {
                        return "Y";
                    }
                    return WinUtils.mountWebDAV(FileSyncSetupPanel.this.serverClient, c, FileSyncSetupPanel.this.webDAVURL);
                }
                catch (Exception exception) {
                    return "N" + exception.getMessage();
                }
            }

            @Override
            public void finished() {
                String string = (String)this.get();
                if (string != null) {
                    if (string.startsWith("Y")) {
                        String[] stringArray;
                        for (final String string2 : stringArray = string.substring(1).split("\\s")) {
                            if (string2.length() != 2 || string2.charAt(1) != ':') continue;
                            FileSyncSetupPanel.this.getController().getIOProvider().startIO(new Runnable(){

                                @Override
                                public void run() {
                                    PathUtils.openFile(Paths.get(string2, new String[0]));
                                }
                            });
                            break;
                        }
                    } else if (string.startsWith("N")) {
                        String[] stringArray = Help.hasWiki(FileSyncSetupPanel.this.getController()) ? new String[]{Translation.get("general.ok"), Translation.get("general.help")} : new String[]{Translation.get("general.ok")};
                        int n = DialogFactory.genericDialog(FileSyncSetupPanel.this.getController(), Translation.get("exp_folder_view.webdav_failure_title"), Translation.get("exp_folder_view.webdav_failure_text", string.substring(1)), stringArray, 0, GenericDialogType.ERROR);
                        if (n == 1) {
                            Help.openWikiArticle(FileSyncSetupPanel.this.getController(), "WebDAV");
                        }
                    }
                }
            }
        };
        activityVisualizationWorker.start();
    }

    private JComponent createLocationField() {
        FormLayout formLayout = new FormLayout("120dlu, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.locationTF = new JTextField();
        this.locationTF.setEditable(false);
        this.locationTF.setText((String)this.locationModel.getValue());
        panelBuilder.add((Component)this.locationTF, cellConstraints.xy(1, 1));
        JButtonMini jButtonMini = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("exp.preferences.expert.select_directory_text"));
        jButtonMini.addActionListener(new MyActionListener());
        panelBuilder.add((Component)jButtonMini, cellConstraints.xy(3, 1));
        panelBuilder.getPanel().setName("locationField");
        return panelBuilder.getPanel();
    }

    private void updateLocationComponents() {
        String string = (String)this.locationModel.getValue();
        this.locationTF.setText(string);
    }

    private class WebDAVConnectionTask
    implements Runnable {
        private WebDAVConnectionTask() {
        }

        @Override
        public void run() {
            FileSyncSetupPanel.this.disableLocalSync();
            FileSyncSetupPanel.this.createWebdavConnection();
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)FileSyncSetupPanel.this.locationModel.getValue();
            List<Path> list = DialogFactory.chooseDirectory(FileSyncSetupPanel.this.getController().getUIController(), string, false);
            if (!list.isEmpty()) {
                Path path = list.get(0);
                for (Folder folder : FileSyncSetupPanel.this.getController().getFolderRepository().getFolders(true)) {
                    if (!folder.getLocalBase().equals(path)) continue;
                    DialogFactory.genericDialog(FileSyncSetupPanel.this.getController(), Translation.get("exp.preferences.expert.duplicate_local_base_title"), Translation.get("exp.preferences.expert.duplicate_local_base_message", folder.getName()), GenericDialogType.ERROR);
                    return;
                }
                FileSyncSetupPanel.this.locationModel.setValue(path.toAbsolutePath().toString());
            }
        }
    }
}

