/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.FolderSetupPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jwf.WizardPanel;

public class ConfirmDiskLocationPanel
extends PFWizardPanel {
    private Path localBase;
    private JCheckBox backupByOnlineStorageBox;
    private JCheckBox sendInviteAfterCB;
    private JLabel folderSizeLabel;

    public ConfirmDiskLocationPanel(Controller controller, Path path) {
        super(controller);
        this.localBase = path;
    }

    @Override
    public WizardPanel next() {
        this.getWizardContext().setAttribute("disklocation.localbase", this.localBase);
        String string = PathUtils.getSuggestedFolderName(this.localBase);
        this.getWizardContext().setAttribute("disklocation.initial_folder_name", string);
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            return new FolderSetupPanel(this.getController());
        }
        FolderInfo folderInfo = FolderInfoFactory.newTopFolder(string);
        this.getWizardContext().setAttribute("disklocation.folder_info", folderInfo);
        this.getWizardContext().setAttribute("disklocation.sync_profile", SyncProfile.AUTOMATIC_SYNCHRONIZATION);
        this.getWizardContext().setAttribute("disklocation.prompt_text", Translation.get("wizard.what_to_do.invite.select_local"));
        TextPanelPanel textPanelPanel = new TextPanelPanel(this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.success_join"));
        this.getWizardContext().setAttribute("successpanel", textPanelPanel);
        return new FolderCreatePanel(this.getController());
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public boolean validateNext() {
        this.getWizardContext().setAttribute("disklocation.send_invitations", this.sendInviteAfterCB.isSelected());
        this.getWizardContext().setAttribute("folder_create.backup_by_os", this.backupByOnlineStorageBox.isSelected());
        return true;
    }

    @Override
    protected JPanel buildContent() {
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref, 3dlu, max(pref;100dlu), 0", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(Translation.get("general.directory"));
        int n = 1;
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
        panelBuilder.add((Component)new JLabel(this.localBase.toAbsolutePath().toString()), cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.folderSizeLabel, cellConstraints.xyw(1, n += 2, 5));
        if (this.getController().getOSClient().isBackupByDefault() && PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.backupByOnlineStorageBox, cellConstraints.xyw(1, n += 2, 5));
        }
        if (this.getController().isBackupOnly() || !ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.sendInviteAfterCB.setSelected(false);
        } else {
            panelBuilder.add((Component)this.sendInviteAfterCB, cellConstraints.xyw(1, n += 2, 5));
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        this.folderSizeLabel = new JLabel();
        boolean bl = this.getController().getOSClient().isBackupByDefault() && Boolean.TRUE.equals(this.getWizardContext().getAttribute("folder_create.backup_by_os"));
        this.backupByOnlineStorageBox = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.backup_by_online_storage"));
        if (bl) {
            this.backupByOnlineStorageBox.setSelected(true);
        }
        this.backupByOnlineStorageBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ConfirmDiskLocationPanel.this.backupByOnlineStorageBox.isSelected()) {
                    ConfirmDiskLocationPanel.this.getController().getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
                }
            }
        });
        this.backupByOnlineStorageBox.setOpaque(false);
        boolean bl2 = Boolean.TRUE.equals(this.getWizardContext().getAttribute("disklocation.send_invitations"));
        this.sendInviteAfterCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.wizard.choose_disk_location.send_invitation"));
        this.sendInviteAfterCB.setOpaque(false);
        this.sendInviteAfterCB.setSelected(bl2);
    }

    @Override
    protected String getTitle() {
        return Translation.get("exp.wizard.choose_disk_location.options");
    }
}

