/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.security.OnlineStorageSubscription;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.dialog.LinkFolderOnlineDialog;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.ProUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jwf.WizardPanel;

public class ChooseMultiDiskLocationPanel
extends PFWizardPanel {
    private Map<String, UserDirectory> userDirectories;
    private WizardPanel next;
    private JLabel folderSizeLabel;
    private LinkLabel warningLabel;
    private JComponent customDirectoryComp;
    private JList<String> customDirectoryList;
    private DefaultListModel<String> customDirectoryListModel;
    private JCheckBox backupByOnlineStorageBox;
    private JCheckBox manualSyncCheckBox;
    private JCheckBox sendInviteAfterCB;
    private Action addAction;
    private Action removeAction;
    private JButton removeButton;
    private Action linkAction;
    private JButton linkButton;
    private String initialDirectory;
    private List<JCheckBox> boxes;
    private ServerClientListener listener;
    private final boolean cancelNotFinish;
    private Map<Path, String> links;

    public ChooseMultiDiskLocationPanel(Controller controller, WizardPanel wizardPanel, boolean bl) {
        super(controller);
        Reject.ifNull(wizardPanel, "Next wizard panel is null");
        this.next = wizardPanel;
        this.links = new HashMap<Path, String>();
        this.cancelNotFinish = bl;
    }

    @Override
    public WizardPanel next() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        boolean bl = this.getGBsAllowed() > 0 || ProUtil.isTrial(this.getController());
        return this.countSelectedFolders() > 0 && (!bl || !this.warningLabel.getUIComponent().isVisible());
    }

    private int getGBsAllowed() {
        try {
            return (Integer)this.getController().getUIController().getApplicationModel().getLicenseModel().getGbAllowedModel().getValue();
        }
        catch (Exception exception) {
            Logger.getAnonymousLogger().log(Level.WARNING, exception.toString(), exception);
            return -1;
        }
    }

    private int countSelectedFolders() {
        int n = this.customDirectoryListModel.getSize();
        for (JCheckBox jCheckBox : this.boxes) {
            if (!jCheckBox.isSelected() || !jCheckBox.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean validateNext() {
        ArrayList<FolderCreateItem> arrayList = new ArrayList<FolderCreateItem>();
        SyncProfile syncProfile = (SyncProfile)this.getWizardContext().getAttribute("disklocation.sync_profile");
        Reject.ifNull(syncProfile, "No default sync profile");
        for (Map.Entry<String, UserDirectory> entry : this.userDirectories.entrySet()) {
            for (JCheckBox jCheckBox : this.boxes) {
                if (!jCheckBox.getText().equals(entry.getKey()) || !jCheckBox.isSelected() || !jCheckBox.isEnabled()) continue;
                FolderCreateItem folderCreateItem = new FolderCreateItem(entry.getValue().getDirectory());
                folderCreateItem.setArchiveHistory(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
                folderCreateItem.setSyncProfile(syncProfile);
                folderCreateItem.setFolderInfo(ChooseMultiDiskLocationPanel.createFolderInfo(entry.getKey()));
                arrayList.add(folderCreateItem);
            }
        }
        for (int i = 0; i < this.customDirectoryListModel.size(); ++i) {
            String string = this.customDirectoryListModel.getElementAt(i);
            Iterator iterator = Paths.get(string, new String[0]);
            FolderCreateItem folderCreateItem = new FolderCreateItem((Path)((Object)iterator));
            folderCreateItem.setArchiveHistory(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(this.getController()));
            folderCreateItem.setSyncProfile(syncProfile);
            arrayList.add(folderCreateItem);
        }
        for (Map.Entry<Path, String> entry : this.links.entrySet()) {
            entry.getKey();
            for (FolderCreateItem folderCreateItem : arrayList) {
                if (!folderCreateItem.getLocalBase().equals(entry.getKey())) continue;
                folderCreateItem.setLinkToOnlineFolder(entry.getValue());
            }
        }
        this.getWizardContext().setAttribute("disklocation.folder_create_items", arrayList);
        this.getWizardContext().setAttribute("folder_create.backup_by_os", this.backupByOnlineStorageBox.isSelected());
        this.getWizardContext().setAttribute("disklocation.send_invitations", this.sendInviteAfterCB.isSelected() && this.countSelectedFolders() <= 1);
        if (this.manualSyncCheckBox.isSelected()) {
            this.getWizardContext().setAttribute("disklocation.sync_profile", SyncProfile.MANUAL_SYNCHRONIZATION);
        }
        return true;
    }

    @Override
    protected JPanel buildContent() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 1 + this.boxes.size() / 4; ++i) {
            stringBuilder.append("pref, 3dlu, ");
        }
        String string = stringBuilder + "9dlu, min(40dlu;pref), 3dlu, pref, 12dlu, pref, 3dlu, max(16dlu;pref), 12dlu, pref";
        FormLayout formLayout = new FormLayout("60dlu, 15dlu, 60dlu, 15dlu, 60dlu, 15dlu, 60dlu, 0:grow", string);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        int n2 = 1;
        Object object = this.boxes.iterator();
        while (object.hasNext()) {
            JCheckBox jCheckBox = object.next();
            panelBuilder.add((Component)jCheckBox, cellConstraints.xy(n2, n));
            if (n2 == 1) {
                n2 = 3;
                continue;
            }
            if (n2 == 3) {
                n2 = 5;
                continue;
            }
            if (n2 == 5) {
                n2 = 7;
                continue;
            }
            n += 2;
            n2 = 1;
        }
        panelBuilder.add((Component)this.customDirectoryComp, cellConstraints.xyw(1, n += 3, 7));
        panelBuilder.add((Component)this.createCustomButtons(), cellConstraints.xyw(1, n += 2, 7));
        n += 2;
        if (this.getController().getOSClient().isBackupByDefault() && PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.add((Component)this.backupByOnlineStorageBox, cellConstraints.xyw(1, n, 3));
        }
        if ((object = this.getWizardContext().getAttribute("disklocation.sync_profile")) != null && object.equals(SyncProfile.AUTOMATIC_SYNCHRONIZATION)) {
            panelBuilder.add((Component)this.manualSyncCheckBox, cellConstraints.xyw(5, n, 3));
        }
        n += 2;
        if (this.getController().isBackupOnly() || !ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            this.sendInviteAfterCB.setSelected(false);
        } else {
            panelBuilder.add((Component)this.sendInviteAfterCB, cellConstraints.xyw(1, n, 3));
        }
        panelBuilder.add((Component)this.warningLabel.getUIComponent(), cellConstraints.xyw(1, n += 2, 6));
        return panelBuilder.getPanel();
    }

    private JPanel createCustomButtons() {
        FormLayout formLayout = new FormLayout("pref, pref, pref, pref, 0:grow, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)new JButtonMini(this.addAction), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.removeButton, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.linkButton, cellConstraints.xy(3, 1));
        ActionLabel actionLabel = new ActionLabel(this.getController(), this.addAction);
        panelBuilder.add((Component)actionLabel.getUIComponent(), cellConstraints.xy(4, 1));
        panelBuilder.add((Component)this.folderSizeLabel, cellConstraints.xy(6, 1));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    @Override
    protected void initComponents() {
        this.initialDirectory = this.getController().getFolderRepository().getFoldersBasedirString();
        this.userDirectories = UserDirectories.getUserDirectories(this.getController());
        this.folderSizeLabel = new JLabel();
        this.warningLabel = new LinkLabel(this.getController(), Translation.get("wizard.activation.order_now"), ProUtil.getBuyNowURL(this.getController()));
        this.warningLabel.setVisible(false);
        this.boxes = new ArrayList<JCheckBox>();
        this.addAction = new MyAddAction(this.getController());
        this.removeAction = new MyRemoveAction(this.getController());
        this.removeButton = new JButtonMini(this.removeAction);
        this.linkAction = new MyLinkAction(this.getController());
        this.linkButton = new JButtonMini(this.linkAction);
        this.customDirectoryListModel = new DefaultListModel();
        this.customDirectoryList = new JList<String>(this.customDirectoryListModel);
        this.customDirectoryComp = new JScrollPane(this.customDirectoryList);
        this.customDirectoryList.setSelectionMode(0);
        this.customDirectoryList.addListSelectionListener(new MyListSelectionListener());
        this.customDirectoryList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                ChooseMultiDiskLocationPanel.this.customDirectoryComp.setVisible(ChooseMultiDiskLocationPanel.this.customDirectoryList.getModel().getSize() > 0);
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                ChooseMultiDiskLocationPanel.this.customDirectoryComp.setVisible(ChooseMultiDiskLocationPanel.this.customDirectoryList.getModel().getSize() > 0);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                ChooseMultiDiskLocationPanel.this.customDirectoryComp.setVisible(ChooseMultiDiskLocationPanel.this.customDirectoryList.getModel().getSize() > 0);
            }
        });
        this.customDirectoryComp.setVisible(false);
        boolean bl = this.getController().getOSClient().isBackupByDefault() && Boolean.TRUE.equals(this.getWizardContext().getAttribute("folder_create.backup_by_os"));
        this.backupByOnlineStorageBox = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.backup_by_online_storage"));
        if (bl) {
            this.backupByOnlineStorageBox.setSelected(true);
        }
        this.backupByOnlineStorageBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ChooseMultiDiskLocationPanel.this.backupByOnlineStorageBox.isSelected()) {
                    ChooseMultiDiskLocationPanel.this.getController().getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
                }
                ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
            }
        });
        this.backupByOnlineStorageBox.setOpaque(false);
        this.backupByOnlineStorageBox.setVisible(ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()) == false);
        this.manualSyncCheckBox = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.maual_sync"));
        this.manualSyncCheckBox.setOpaque(false);
        boolean bl2 = Boolean.TRUE.equals(this.getWizardContext().getAttribute("disklocation.send_invitations"));
        this.sendInviteAfterCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.wizard.choose_disk_location.send_invitation"));
        this.sendInviteAfterCB.setOpaque(false);
        this.sendInviteAfterCB.setSelected(bl2);
        this.enableRemoveLinkAction();
        this.listener = new MyServerClientListener();
        if (!ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue()) {
            JCheckBox jCheckBox = new JCheckBox(Translation.get("exp.wizard.choose_multi_disk_location.all_files"));
            jCheckBox.setOpaque(false);
            jCheckBox.addActionListener(new MyAllActionListner());
            this.boxes.add(jCheckBox);
            boolean bl3 = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
            for (String string : this.userDirectories.keySet()) {
                if (!bl3 && "APP DATA".equalsIgnoreCase(string)) continue;
                JCheckBox jCheckBox2 = new JCheckBox(string);
                jCheckBox2.setOpaque(false);
                jCheckBox2.addActionListener(new MyActionListener());
                this.boxes.add(jCheckBox2);
            }
        }
    }

    @Override
    protected void afterDisplay() {
        super.afterDisplay();
        if (this.listener != null) {
            this.getController().getOSClient().addListener(this.listener);
        }
        this.startFolderSizeCalculator();
        this.startConfigureCheckboxes();
    }

    @Override
    public void finish() {
        if (this.listener != null) {
            this.getController().getOSClient().removeListener(this.listener);
            super.finish();
        }
    }

    @Override
    public boolean canFinish() {
        return !this.cancelNotFinish;
    }

    @Override
    public boolean canCancel() {
        return this.cancelNotFinish;
    }

    @Override
    protected String getTitle() {
        String string = (String)this.getWizardContext().getAttribute("disklocation.prompt_text");
        if (StringUtils.isNotBlank(string)) {
            return string;
        }
        return Translation.get("exp.wizard.choose_multi_disk_location.title");
    }

    private void startFolderSizeCalculator() {
        this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.calculating_directory_size"));
        this.folderSizeLabel.setForeground(SystemColor.textText);
        new MyFolderSizeSwingWorker().execute();
    }

    private void enableRemoveLinkAction() {
        boolean bl = !this.customDirectoryList.getSelectionModel().isSelectionEmpty();
        this.removeAction.setEnabled(bl);
        this.removeButton.setVisible(this.removeAction.isEnabled());
        this.linkAction.setEnabled(bl);
        this.linkButton.setVisible(this.linkAction.isEnabled());
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        if (this.countSelectedFolders() <= 1) {
            this.sendInviteAfterCB.setEnabled(true);
            this.sendInviteAfterCB.setVisible(true);
        } else {
            this.sendInviteAfterCB.setSelected(false);
            this.sendInviteAfterCB.setEnabled(false);
            this.sendInviteAfterCB.setVisible(false);
        }
    }

    private void startConfigureCheckboxes() {
        new MyConfigureCBSwingWorker().execute();
    }

    private static FolderInfo createFolderInfo(String string) {
        return FolderInfoFactory.newTopFolder(string);
    }

    public void link(Path path, String string) {
        if (StringUtils.isBlank(string)) {
            this.links.remove(path);
        } else {
            this.links.put(path, string);
            this.backupByOnlineStorageBox.setSelected(false);
        }
        this.backupByOnlineStorageBox.setVisible(this.links.isEmpty());
    }

    private long calculateTotalLocalSharedSize() {
        long l = 0L;
        for (Folder folder : this.getController().getFolderRepository().getFolders()) {
            l += folder.getStatistic().getSize(this.getController().getMySelf());
        }
        return l;
    }

    private class MyAddAction
    extends BaseAction {
        MyAddAction(Controller controller) {
            super("action_add_directory", controller);
            this.putValue("Name", Translation.get("exp.wizard.choose_multi_disk_location.select_additional"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            ArrayList<String> arrayList = new ArrayList<String>();
            ServerClient serverClient = this.getController().getOSClient();
            if (serverClient.isConnected()) {
                object3 = serverClient.getAccountFolders().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    arrayList.add(((FolderInfo)object2).getName());
                }
            }
            if ((object3 = DialogFactory.chooseDirectory(this.getUIController(), ChooseMultiDiskLocationPanel.this.initialDirectory == null ? null : Paths.get(ChooseMultiDiskLocationPanel.this.initialDirectory, new String[0]), arrayList, true)).isEmpty()) {
                return;
            }
            object2 = this.getController().getFolderRepository().getFoldersBasedir();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (Path)iterator.next();
                if (!object.equals(object2)) continue;
                DialogFactory.genericDialog(this.getController(), Translation.get("general.directory"), Translation.get("general.basedir_error.text"), GenericDialogType.ERROR);
                return;
            }
            if (ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = (Path)iterator.next();
                    if (object.getParent().equals(object2)) continue;
                    DialogFactory.genericDialog(this.getController(), Translation.get("general.directory"), Translation.get("general.outside_basedir_error.text", this.getController().getFolderRepository().getFoldersBasedirString()), GenericDialogType.ERROR);
                    return;
                }
            }
            ChooseMultiDiskLocationPanel.this.initialDirectory = ((Path)object3.get(0)).toAbsolutePath().toString();
            boolean bl = false;
            object = object3.iterator();
            while (object.hasNext()) {
                Path path = (Path)object.next();
                if (ChooseMultiDiskLocationPanel.this.customDirectoryListModel.contains(path.toAbsolutePath().toString())) continue;
                ChooseMultiDiskLocationPanel.this.customDirectoryListModel.addElement(path.toAbsolutePath().toString());
                ChooseMultiDiskLocationPanel.this.customDirectoryList.setSelectedIndex(ChooseMultiDiskLocationPanel.this.customDirectoryListModel.size() - 1);
                bl = true;
            }
            if (bl) {
                ChooseMultiDiskLocationPanel.this.updateButtons();
                ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
            }
        }
    }

    private class MyRemoveAction
    extends BaseAction {
        MyRemoveAction(Controller controller) {
            super("action_remove_directory", controller);
            this.putValue("Name", "");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChooseMultiDiskLocationPanel.this.customDirectoryListModel.remove(ChooseMultiDiskLocationPanel.this.customDirectoryList.getSelectedIndex());
            ChooseMultiDiskLocationPanel.this.updateButtons();
            ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
        }
    }

    private class MyLinkAction
    extends BaseAction {
        MyLinkAction(Controller controller) {
            super("action_link_directory", controller);
            this.putValue("Name", "");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ChooseMultiDiskLocationPanel.this.customDirectoryList.getSelectedValue();
            Path path = Paths.get(string, new String[0]);
            LinkFolderOnlineDialog linkFolderOnlineDialog = new LinkFolderOnlineDialog(this.getController(), ChooseMultiDiskLocationPanel.this, path, (String)ChooseMultiDiskLocationPanel.this.links.get(path));
            linkFolderOnlineDialog.open();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ChooseMultiDiskLocationPanel.this.enableRemoveLinkAction();
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
            ChooseMultiDiskLocationPanel.this.startConfigureCheckboxes();
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
            ChooseMultiDiskLocationPanel.this.startConfigureCheckboxes();
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            ChooseMultiDiskLocationPanel.this.startConfigureCheckboxes();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            ChooseMultiDiskLocationPanel.this.startConfigureCheckboxes();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyAllActionListner
    implements ActionListener {
        private MyAllActionListner() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            for (JCheckBox jCheckBox : ChooseMultiDiskLocationPanel.this.boxes) {
                if (!jCheckBox.isEnabled()) continue;
                jCheckBox.setSelected(bl);
            }
            ChooseMultiDiskLocationPanel.this.updateButtons();
            ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChooseMultiDiskLocationPanel.this.updateButtons();
            ChooseMultiDiskLocationPanel.this.startFolderSizeCalculator();
        }
    }

    private class MyFolderSizeSwingWorker
    extends SwingWorker<Void, Void> {
        private int nDirectories;
        private int recursiveFileCount;
        private long totalDirectorySize;
        private boolean valid = true;

        private MyFolderSizeSwingWorker() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Void doInBackground() throws Exception {
            try {
                void var3_13;
                this.recursiveFileCount = 0;
                this.totalDirectorySize = 0L;
                ArrayList<Path> arrayList = new ArrayList<Path>();
                for (Map.Entry iterator : ChooseMultiDiskLocationPanel.this.userDirectories.entrySet()) {
                    for (Object object : ChooseMultiDiskLocationPanel.this.boxes) {
                        if (!((AbstractButton)object).getText().equals(iterator.getKey()) || !((AbstractButton)object).isSelected() || !((Component)object).isEnabled()) continue;
                        Object object2 = ((UserDirectory)iterator.getValue()).getDirectory();
                        arrayList.add((Path)object2);
                    }
                }
                for (int i = 0; i < ChooseMultiDiskLocationPanel.this.customDirectoryListModel.getSize(); ++i) {
                    String string = (String)ChooseMultiDiskLocationPanel.this.customDirectoryListModel.elementAt(i);
                    Path path = Paths.get(string, new String[0]);
                    arrayList.add(path);
                }
                for (Path path : arrayList) {
                    Long[] longArray = PathUtils.calculateDirectorySizeAndCount(path);
                    this.totalDirectorySize += longArray[0].longValue();
                    this.recursiveFileCount = (int)((long)this.recursiveFileCount + longArray[1]);
                }
                this.nDirectories = arrayList.size();
                ChooseMultiDiskLocationPanel.this.getWizardContext().setAttribute("file_count", this.recursiveFileCount);
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : ChooseMultiDiskLocationPanel.this.userDirectories.entrySet()) {
                    for (Object object2 : ChooseMultiDiskLocationPanel.this.boxes) {
                        if (!((AbstractButton)object2).getText().equals(entry.getKey()) || !((AbstractButton)object2).isSelected() || !((Component)object2).isEnabled()) continue;
                        Path path = ((UserDirectory)entry.getValue()).getDirectory();
                        arrayList2.add(path);
                    }
                }
                boolean bl = false;
                while (var3_13 < ChooseMultiDiskLocationPanel.this.customDirectoryListModel.getSize()) {
                    Object object;
                    String string = (String)ChooseMultiDiskLocationPanel.this.customDirectoryListModel.elementAt((int)var3_13);
                    object = Paths.get(string, new String[0]);
                    arrayList2.add(object);
                    ++var3_13;
                }
                if (arrayList.size() != arrayList2.size() || !arrayList.containsAll(arrayList2)) {
                    this.valid = false;
                }
            }
            catch (Exception exception) {
                Logger.getAnonymousLogger().log(Level.WARNING, exception.toString(), exception);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            if (this.valid) {
                try {
                    boolean bl;
                    long l;
                    ChooseMultiDiskLocationPanel.this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.total_directory_size", Format.formatBytes(this.totalDirectorySize), Format.formatLong(this.recursiveFileCount)));
                    ChooseMultiDiskLocationPanel.this.warningLabel.setText("");
                    ChooseMultiDiskLocationPanel.this.warningLabel.setIcon(null);
                    ChooseMultiDiskLocationPanel.this.warningLabel.setVisible(false);
                    if (ChooseMultiDiskLocationPanel.this.backupByOnlineStorageBox.isSelected()) {
                        ServerClient serverClient = ChooseMultiDiskLocationPanel.this.getController().getOSClient();
                        OnlineStorageSubscription onlineStorageSubscription = serverClient.getAccount().getOSSubscription();
                        if (serverClient.isConnected()) {
                            long l2 = onlineStorageSubscription.getStorageSize();
                            long l3 = serverClient.getAccountDetails().getSpaceUsed();
                            if (l3 + this.totalDirectorySize > l2) {
                                ChooseMultiDiskLocationPanel.this.warningLabel.setVisible(true);
                                ChooseMultiDiskLocationPanel.this.warningLabel.setText(Translation.get("exp.wizard.choose_disk_location.os_over_size"));
                                ChooseMultiDiskLocationPanel.this.warningLabel.setIcon(Icons.getIconById("warning.icon"));
                            }
                        }
                    }
                    boolean bl2 = (l = (long)(ChooseMultiDiskLocationPanel.this.getGBsAllowed() * 1024 * 1024 * 1024)) > 0L && ChooseMultiDiskLocationPanel.this.calculateTotalLocalSharedSize() + this.totalDirectorySize > l;
                    boolean bl3 = bl = ProUtil.isTrial(ChooseMultiDiskLocationPanel.this.getController()) && this.nDirectories + ChooseMultiDiskLocationPanel.this.getController().getFolderRepository().getFoldersCount() > 3;
                    if (bl2 || bl) {
                        ChooseMultiDiskLocationPanel.this.warningLabel.setVisible(true);
                        ChooseMultiDiskLocationPanel.this.warningLabel.setText(Translation.get("exp.wizard.choose_disk_location.os_over_size"));
                        ChooseMultiDiskLocationPanel.this.warningLabel.setIcon(Icons.getIconById("warning.icon"));
                    }
                }
                catch (Exception exception) {
                    Logger.getAnonymousLogger().log(Level.WARNING, exception.toString(), exception);
                }
                finally {
                    ChooseMultiDiskLocationPanel.this.updateButtons();
                }
            }
            ChooseMultiDiskLocationPanel.this.updateButtons();
        }
    }

    private class MyConfigureCBSwingWorker
    extends SwingWorker<Void, Void> {
        private MyConfigureCBSwingWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            Collection<Folder> collection = ChooseMultiDiskLocationPanel.this.getController().getFolderRepository().getFolders();
            ServerClient serverClient = ChooseMultiDiskLocationPanel.this.getController().getOSClient();
            block0: for (Map.Entry entry : ChooseMultiDiskLocationPanel.this.userDirectories.entrySet()) {
                Path path = ((UserDirectory)entry.getValue()).getDirectory();
                boolean bl = false;
                for (Folder folder : collection) {
                    if (!folder.getLocalBase().equals(path)) continue;
                    bl = true;
                    break;
                }
                boolean bl2 = false;
                if (!bl && serverClient != null && serverClient.isConnected() && serverClient.isLoggedIn()) {
                    Collection<FolderInfo> collection2 = serverClient.getAccountFolders();
                    for (Serializable serializable : collection2) {
                        if (!serializable.getName().equals(entry.getKey())) continue;
                        bl2 = true;
                        break;
                    }
                }
                for (Object object : ChooseMultiDiskLocationPanel.this.boxes) {
                    Serializable serializable;
                    if (!((AbstractButton)object).getText().equals(entry.getKey())) continue;
                    serializable = new Font(((Component)object).getFont().getName(), !bl && bl2 ? 1 : 0, ((Component)object).getFont().getSize());
                    ((JComponent)object).setFont((Font)serializable);
                    ((AbstractButton)object).setEnabled(!bl);
                    if (bl) {
                        ((JComponent)object).setToolTipText(Translation.get("exp.wizard.choose_disk_location.already_synchronized"));
                        ((AbstractButton)object).setSelected(true);
                        continue block0;
                    }
                    if (bl2) {
                        ((JComponent)object).setToolTipText(Translation.get("exp.wizard.choose_disk_location.already_online"));
                        continue block0;
                    }
                    ((JComponent)object).setToolTipText(null);
                    continue block0;
                }
            }
            return null;
        }
    }
}

