/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.widget;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.util.ColorUtil;
import de.dal33t.powerfolder.ui.util.CursorUtils;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ActionLabel
extends PFComponent {
    private JLabel uiComponent;
    private volatile boolean enabled = true;
    private String text;
    private Action action;
    private volatile boolean mouseOver;
    private boolean neverUnderline;
    private boolean underline;

    public ActionLabel(Controller controller, final Action action) {
        super(controller);
        Reject.ifNull(action, "Action");
        this.action = action;
        this.underline = PreferencesEntry.UNDERLINE_LINKS.getValueBoolean(this.getController());
        this.neverUnderline = false;
        this.uiComponent = new JLabel();
        this.text = (String)action.getValue("Name");
        this.displayText();
        String string = (String)action.getValue("ShortDescription");
        if (string != null && string.length() > 0) {
            this.uiComponent.setToolTipText(string);
        }
        Reject.ifNull(action, "Action listener is null");
        this.uiComponent.addMouseListener(new MyMouseAdapter());
        CursorUtils.setHandCursor(this.uiComponent);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ActionLabel.this.setEnabled(action.isEnabled());
                if ("Name".equals(propertyChangeEvent.getPropertyName())) {
                    ActionLabel.this.text = (String)action.getValue("Name");
                    ActionLabel.this.displayText();
                } else if ("ShortDescription".equals(propertyChangeEvent.getPropertyName())) {
                    String string = (String)action.getValue("ShortDescription");
                    if (string != null && string.length() > 0) {
                        ActionLabel.this.uiComponent.setToolTipText(string);
                    } else {
                        ActionLabel.this.uiComponent.setToolTipText("");
                    }
                }
            }
        });
        this.setEnabled(action.isEnabled());
    }

    public JComponent getUIComponent() {
        return this.uiComponent;
    }

    public void setText(String string) {
        this.text = string;
        this.displayText();
    }

    public void setIcon(Icon icon) {
        this.uiComponent.setIcon(icon);
    }

    public void setToolTipText(String string) {
        this.uiComponent.setToolTipText(string);
    }

    public void setForeground(Color color) {
        this.uiComponent.setForeground(color);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.displayText();
    }

    public void setNeverUnderline(boolean bl) {
        this.neverUnderline = bl;
        if (bl) {
            CursorUtils.setDefaultCursor(this.uiComponent);
        } else {
            CursorUtils.setHandCursor(this.uiComponent);
        }
        this.displayText();
    }

    public void setVisible(boolean bl) {
        this.uiComponent.setVisible(bl);
    }

    public void setFontSize(int n) {
        SimpleComponentFactory.setFont(this.uiComponent, n, this.uiComponent.getFont().getStyle());
    }

    public void setFontStyle(int n) {
        SimpleComponentFactory.setFont(this.uiComponent, this.uiComponent.getFont().getSize(), n);
    }

    public void convertToBigLabel() {
        this.uiComponent.setIcon(Icons.getIconById("arrow_right.icon"));
        this.setFontSize(15);
    }

    public void displayText() {
        if (this.enabled) {
            if (!this.neverUnderline && (this.mouseOver || this.underline)) {
                if (StringUtils.isNotBlank(this.text)) {
                    Color color = ColorUtil.getTextForegroundColor();
                    String string = ColorUtil.getRgbForColor(color);
                    this.putText("<html><font color=\"" + string + "\"><a href=\"#\">" + this.text + "</a></font></html>");
                } else {
                    this.putText(" ");
                }
            } else {
                this.uiComponent.setForeground(SystemColor.textText);
                this.putText(this.text);
            }
        } else {
            this.uiComponent.setForeground(SystemColor.textInactiveText);
            this.putText(this.text);
        }
    }

    private void putText(String string) {
        String string2 = this.uiComponent.getText();
        if (string2 == null) {
            if (string != null) {
                this.uiComponent.setText(string);
            }
            return;
        }
        if (!string2.equals(string)) {
            this.uiComponent.setText(string);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ActionLabel.this.mouseOver = true;
            ActionLabel.this.displayText();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ActionLabel.this.mouseOver = false;
            ActionLabel.this.displayText();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ActionLabel.this.enabled) {
                ActionLabel.this.action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "clicked"));
            }
        }
    }
}

