/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.event.NetworkingModeEvent;
import de.dal33t.powerfolder.event.NetworkingModeListener;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.KnownNodes;
import de.dal33t.powerfolder.message.KnownNodesExt;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.SingleMessageProducer;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.NeverAskAgainResponse;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LimitedConnectivityChecker {
    private static final Logger log = Logger.getLogger(LimitedConnectivityChecker.class.getName());
    private static final String LIMITED_CONNECTIVITY_TEST_SUCCESSFULLY_STRING = "LIMITED CONNECTIVITY TEST SUCCESSFULLY";
    private Controller controller;
    private String host;
    private int port;

    public LimitedConnectivityChecker(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        this.controller = controller;
    }

    public boolean hasLimitedConnecvitiy() {
        if (!this.controller.getNodeManager().getMySelf().isSupernode()) {
            if (this.controller.getOSClient().isConnected()) {
                log.fine("No limited connectivity. Connected to the Online Storage");
                return false;
            }
            if (this.controller.getIOProvider().getRelayedConnectionManager().getRelay() != null) {
                log.fine("No limited connectivity. Connected to a relay");
                return false;
            }
        }
        if (!this.resolveHostAndPort()) {
            log.warning("Unable resolve own host");
            return true;
        }
        boolean bl = this.isConnectPossible() || this.isConnectPossible() || this.isConnectPossible();
        return !bl;
    }

    public static void install(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        CheckTask checkTask = new CheckTask(controller);
        controller.schedule(checkTask, 30000L);
        controller.addNetworkingModeListener(new MyNetworkingModeListener(controller));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private boolean resolveHostAndPort() {
        String string = ConfigurationEntry.HOSTNAME.getValue(this.controller);
        boolean bl = !StringUtils.isEmpty(string);
        this.port = this.controller.getConnectionListener().getPort();
        if (bl) {
            try {
                InetAddress.getAllByName(string);
                this.host = string;
            }
            catch (UnknownHostException unknownHostException) {
                this.host = null;
            }
        }
        if (StringUtils.isEmpty(this.host)) {
            this.host = this.controller.getDynDnsManager().getIPviaHTTPCheckIP();
        }
        log.finer("Will check connectivity on " + this.host + ":" + this.port);
        return !StringUtils.isEmpty(this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectPossible() {
        URL uRL;
        Reject.ifBlank(this.host, "Hostname or port resolved, resolve it first");
        Reject.ifTrue(this.port <= 0, "Hostname or port resolved, resolve it first");
        try {
            uRL = new URL("http://checkconnectivity.powerfolder.com/check.php?host=" + this.host + "&port=" + this.port);
        }
        catch (MalformedURLException malformedURLException) {
            log.log(Level.WARNING, "Limited connectivity check failed for " + this.host + ":" + this.port, malformedURLException);
            return false;
        }
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(30000);
            uRLConnection.setReadTimeout(30000);
            uRLConnection.connect();
            inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(inputStream));
            CharBuffer charBuffer = CharBuffer.allocate(inputStream.available());
            ((Reader)inputStreamReader).read(charBuffer);
            ((Reader)inputStreamReader).close();
            String string = new String(charBuffer.array());
            boolean bl = string.contains(LIMITED_CONNECTIVITY_TEST_SUCCESSFULLY_STRING);
            return bl;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            log.log(Level.WARNING, "Limited connectivity check failed for " + this.host + ":" + this.port + ". " + socketTimeoutException);
            log.log(Level.FINER, "SocketTimeoutException", socketTimeoutException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            log.log(Level.WARNING, "Limited connectivity check failed for " + this.host + ":" + this.port + ". " + iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.log(Level.FINER, "IOException", iOException);
                }
            }
        }
    }

    public static void showConnectivityWarning(final Controller controller) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NeverAskAgainResponse neverAskAgainResponse;
                String string = Help.getWikiArticleURL(controller, "Limited_connectivity");
                if (StringUtils.isBlank(string)) {
                    string = "";
                }
                if ((neverAskAgainResponse = DialogFactory.genericDialog(controller, Translation.get("exp.limited_connection.title"), Translation.get("exp.limited_connection.text", string), new String[]{Translation.get("general.ok")}, 0, GenericDialogType.INFO, Translation.get("exp.limited_connection.dont_autodetect"))).isNeverAskAgain()) {
                    PreferencesEntry.WARN_ON_NO_DIRECT_CONNECTIVITY.setValue(controller, false);
                    log.warning("store do not show this dialog again");
                }
            }
        };
        controller.getUIController().invokeLater(runnable);
    }

    public static class CheckTask
    implements Runnable {
        private Controller controller;

        public CheckTask(Controller controller) {
            this.controller = controller;
        }

        @Override
        public void run() {
            if (this.controller.isLanOnly()) {
                this.controller.setLimitedConnectivity(false);
                return;
            }
            if (!this.controller.getNodeManager().isStarted()) {
                return;
            }
            if (!PreferencesEntry.WARN_ON_NO_DIRECT_CONNECTIVITY.getValueBoolean(this.controller).booleanValue()) {
                return;
            }
            LimitedConnectivityChecker limitedConnectivityChecker = new LimitedConnectivityChecker(this.controller);
            log.fine("Checking for limited connectivity (" + limitedConnectivityChecker.getHost() + ":" + limitedConnectivityChecker.getPort() + ")");
            boolean bl = limitedConnectivityChecker.hasLimitedConnecvitiy();
            this.controller.setLimitedConnectivity(bl);
            if (bl) {
                log.warning("Unable to connect from the Internet to " + limitedConnectivityChecker.getHost() + ":" + limitedConnectivityChecker.getPort());
            } else {
                log.info("Connectivity is good");
            }
            this.setSupernodeState(bl);
        }

        private void setSupernodeState(boolean bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.controller.getConnectionListener().getMyDynDns() != null;
            if (!bl2) {
                return;
            }
            final MemberInfo memberInfo = this.controller.getMySelf().getInfo();
            boolean bl4 = memberInfo.isSupernode = !bl;
            if (!this.controller.getMySelf().getInfo().isSupernode) {
                return;
            }
            log.fine("Acting as supernode on address " + memberInfo.getConnectAddress());
            this.controller.getNodeManager().broadcastMessage(107, new SingleMessageProducer(){

                @Override
                public Message getMessage(boolean bl) {
                    return bl ? new KnownNodesExt(memberInfo) : new KnownNodes(memberInfo);
                }
            }, null);
        }
    }

    private static class MyNetworkingModeListener
    implements NetworkingModeListener {
        private Controller controller;

        private MyNetworkingModeListener(Controller controller) {
            this.controller = controller;
        }

        @Override
        public void setNetworkingMode(NetworkingModeEvent networkingModeEvent) {
            this.controller.getIOProvider().startIO(new CheckTask(this.controller));
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

