/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageSupport {
    private static final Logger log;
    private static final Set<String> supportedReadFileTypes;
    private static final Set<String> supportedWriteFileTypes;
    private static BufferedImage lastImage;
    private static int lastWidth;
    private static int lastHeight;
    private static Image lastResizedImage;
    private static int lastScalingType;

    public static boolean isReadSupportedImage(String string) {
        String string2;
        int n = string.lastIndexOf(46);
        return n > 0 && supportedReadFileTypes.contains(string2 = string.substring(n + 1, string.length()).toLowerCase());
    }

    public static boolean isWriteSupportedImage(String string) {
        return supportedWriteFileTypes.contains(string);
    }

    public static Dimension getResolution(Path path) {
        if (!ImageSupport.isReadSupportedImage(path.getFileName().toString())) {
            throw new IllegalStateException("unsuported image format: " + path);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalStateException("File must exists: " + path);
        }
        try {
            int n = path.getFileName().toString().lastIndexOf(46);
            if (n > 0) {
                String string = path.getFileName().toString().substring(n + 1, path.getFileName().toString().length());
                ImageReader imageReader = ImageSupport.getReader(string);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(path);
                imageReader.setInput(imageInputStream, true);
                int n2 = 0;
                int n3 = imageReader.getWidth(n2);
                int n4 = imageReader.getHeight(n2);
                imageInputStream.close();
                imageReader.dispose();
                return new Dimension(n3, n4);
            }
        }
        catch (Exception exception) {
            log.log(Level.FINER, "Unable to read image: " + path.toAbsolutePath(), exception);
        }
        return null;
    }

    public static BufferedImage getImage(Path path) {
        if (!ImageSupport.isReadSupportedImage(path.getFileName().toString())) {
            throw new IllegalStateException("unsuported image format: " + path);
        }
        if (Files.exists(path, new LinkOption[0])) {
            throw new IllegalStateException("File must exists: " + path);
        }
        try {
            int n = path.getFileName().toString().lastIndexOf(46);
            if (n > 0) {
                String string = path.getFileName().toString().substring(n + 1, path.getFileName().toString().length());
                ImageReader imageReader = ImageSupport.getReader(string);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(path);
                imageReader.setInput(imageInputStream, true);
                int n2 = 0;
                BufferedImage bufferedImage = imageReader.read(n2, null);
                imageInputStream.close();
                imageReader.dispose();
                return bufferedImage;
            }
        }
        catch (Exception exception) {
            log.log(Level.FINER, "Unable to read image: " + path.toAbsolutePath(), exception);
        }
        return null;
    }

    private static ImageReader getReader(String string) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        return iterator.next();
    }

    public static void clearCache() {
        if (lastImage != null) {
            lastImage.flush();
            lastImage = null;
        }
        if (lastResizedImage != null) {
            lastResizedImage.flush();
            lastResizedImage = null;
        }
        lastWidth = -1;
        lastHeight = -1;
        lastScalingType = -1;
    }

    public static Image constrain(BufferedImage bufferedImage, int n, int n2, int n3) {
        if (bufferedImage == lastImage && n == lastWidth && n2 == lastHeight && n3 == lastScalingType) {
            return lastResizedImage;
        }
        ImageSupport.clearCache();
        lastWidth = n;
        lastHeight = n2;
        lastImage = bufferedImage;
        lastScalingType = n3;
        try {
            Image image;
            int n4 = bufferedImage.getWidth(null);
            int n5 = bufferedImage.getHeight(null);
            double d = (double)n4 / (double)n5;
            double d2 = (double)n / (double)n2;
            int n6 = n;
            int n7 = n2;
            if (d2 < d) {
                n7 = (int)((double)n / (double)n4 * (double)n5);
            } else {
                n6 = (int)((double)n2 / (double)n5 * (double)n4);
            }
            if (n3 == 2) {
                BufferedImage bufferedImage2 = new BufferedImage(n6, n7, 8);
                Graphics graphics = bufferedImage2.getGraphics();
                graphics.drawImage(bufferedImage, 0, 0, n6, n7, null);
                graphics.dispose();
                lastResizedImage = bufferedImage2;
                return bufferedImage2;
            }
            lastResizedImage = image = bufferedImage.getScaledInstance(n6, n7, n3);
            return image;
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception", exception);
            return null;
        }
    }

    static {
        Object object;
        log = Logger.getLogger(ImageSupport.class.getName());
        supportedReadFileTypes = new HashSet<String>();
        supportedWriteFileTypes = new HashSet<String>();
        Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iterator.hasNext()) {
            object = iterator.next();
            supportedReadFileTypes.addAll(Arrays.asList(((ImageReaderWriterSpi)object).getFileSuffixes()));
        }
        supportedReadFileTypes.remove("");
        object = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        while (object.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object.next();
            supportedWriteFileTypes.addAll(Arrays.asList(imageWriterSpi.getFileSuffixes()));
        }
    }
}

